#! /usr/bin/python3.3
"""       turtle-example-suite:

              tdemo_peace.py

A very simple drawing suitable as a beginner's
programming example.

Uses only commands, which are also available in
old turtle.py.

Intentionally no variables are used except for the
colorloop:
"""

from turtle import *

def main():
    peacecolors = ("red3",  "orange", "yellow",
                   "seagreen4", "orchid4",
                   "royalblue1", "dodgerblue4")

    reset()
    s = Screen()
    up()
    goto(-320,-195)
    width(70)

    for pcolor in peacecolors:
        color(pcolor)
        down()
        forward(640)
        up()
        backward(640)
        left(90)
        forward(66)
        right(90)

    width(25)
    color("white")
    goto(0,-170)
    down()

    circle(170)
    left(90)
    forward(340)
    up()
    left(180)
    forward(170)
    right(45)
    down()
    forward(170)
    up()
    backward(170)
    left(90)
    down()
    forward(170)
    up()

    goto(0,300) # vanish if hideturtle() is not available ;-)
    return "Done!!"

if __name__ == "__main__":
    main()
    mainloop()
