require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__LINUX_USB_CH9_H)) {
    eval 'sub __LINUX_USB_CH9_H () {1;}' unless defined(&__LINUX_USB_CH9_H);
    require 'linux/types.ph';
    require 'asm/byteorder.ph';
    eval 'sub USB_DIR_OUT () {0;}' unless defined(&USB_DIR_OUT);
    eval 'sub USB_DIR_IN () {0x80;}' unless defined(&USB_DIR_IN);
    eval 'sub USB_TYPE_MASK () {(0x3 << 5);}' unless defined(&USB_TYPE_MASK);
    eval 'sub USB_TYPE_STANDARD () {(0x << 5);}' unless defined(&USB_TYPE_STANDARD);
    eval 'sub USB_TYPE_CLASS () {(0x1 << 5);}' unless defined(&USB_TYPE_CLASS);
    eval 'sub USB_TYPE_VENDOR () {(0x2 << 5);}' unless defined(&USB_TYPE_VENDOR);
    eval 'sub USB_TYPE_RESERVED () {(0x3 << 5);}' unless defined(&USB_TYPE_RESERVED);
    eval 'sub USB_RECIP_MASK () {0x1f;}' unless defined(&USB_RECIP_MASK);
    eval 'sub USB_RECIP_DEVICE () {0x;}' unless defined(&USB_RECIP_DEVICE);
    eval 'sub USB_RECIP_INTERFACE () {0x1;}' unless defined(&USB_RECIP_INTERFACE);
    eval 'sub USB_RECIP_ENDPOINT () {0x2;}' unless defined(&USB_RECIP_ENDPOINT);
    eval 'sub USB_RECIP_OTHER () {0x3;}' unless defined(&USB_RECIP_OTHER);
    eval 'sub USB_RECIP_PORT () {0x4;}' unless defined(&USB_RECIP_PORT);
    eval 'sub USB_RECIP_RPIPE () {0x5;}' unless defined(&USB_RECIP_RPIPE);
    eval 'sub USB_REQ_GET_STATUS () {0x;}' unless defined(&USB_REQ_GET_STATUS);
    eval 'sub USB_REQ_CLEAR_FEATURE () {0x1;}' unless defined(&USB_REQ_CLEAR_FEATURE);
    eval 'sub USB_REQ_SET_FEATURE () {0x3;}' unless defined(&USB_REQ_SET_FEATURE);
    eval 'sub USB_REQ_SET_ADDRESS () {0x5;}' unless defined(&USB_REQ_SET_ADDRESS);
    eval 'sub USB_REQ_GET_DESCRIPTOR () {0x6;}' unless defined(&USB_REQ_GET_DESCRIPTOR);
    eval 'sub USB_REQ_SET_DESCRIPTOR () {0x7;}' unless defined(&USB_REQ_SET_DESCRIPTOR);
    eval 'sub USB_REQ_GET_CONFIGURATION () {0x8;}' unless defined(&USB_REQ_GET_CONFIGURATION);
    eval 'sub USB_REQ_SET_CONFIGURATION () {0x9;}' unless defined(&USB_REQ_SET_CONFIGURATION);
    eval 'sub USB_REQ_GET_INTERFACE () {0xa;}' unless defined(&USB_REQ_GET_INTERFACE);
    eval 'sub USB_REQ_SET_INTERFACE () {0xb;}' unless defined(&USB_REQ_SET_INTERFACE);
    eval 'sub USB_REQ_SYNCH_FRAME () {0xc;}' unless defined(&USB_REQ_SYNCH_FRAME);
    eval 'sub USB_REQ_SET_SEL () {0x30;}' unless defined(&USB_REQ_SET_SEL);
    eval 'sub USB_REQ_SET_ISOCH_DELAY () {0x31;}' unless defined(&USB_REQ_SET_ISOCH_DELAY);
    eval 'sub USB_REQ_SET_ENCRYPTION () {0xd;}' unless defined(&USB_REQ_SET_ENCRYPTION);
    eval 'sub USB_REQ_GET_ENCRYPTION () {0xe;}' unless defined(&USB_REQ_GET_ENCRYPTION);
    eval 'sub USB_REQ_RPIPE_ABORT () {0xe;}' unless defined(&USB_REQ_RPIPE_ABORT);
    eval 'sub USB_REQ_SET_HANDSHAKE () {0xf;}' unless defined(&USB_REQ_SET_HANDSHAKE);
    eval 'sub USB_REQ_RPIPE_RESET () {0xf;}' unless defined(&USB_REQ_RPIPE_RESET);
    eval 'sub USB_REQ_GET_HANDSHAKE () {0x10;}' unless defined(&USB_REQ_GET_HANDSHAKE);
    eval 'sub USB_REQ_SET_CONNECTION () {0x11;}' unless defined(&USB_REQ_SET_CONNECTION);
    eval 'sub USB_REQ_SET_SECURITY_DATA () {0x12;}' unless defined(&USB_REQ_SET_SECURITY_DATA);
    eval 'sub USB_REQ_GET_SECURITY_DATA () {0x13;}' unless defined(&USB_REQ_GET_SECURITY_DATA);
    eval 'sub USB_REQ_SET_WUSB_DATA () {0x14;}' unless defined(&USB_REQ_SET_WUSB_DATA);
    eval 'sub USB_REQ_LOOPBACK_DATA_WRITE () {0x15;}' unless defined(&USB_REQ_LOOPBACK_DATA_WRITE);
    eval 'sub USB_REQ_LOOPBACK_DATA_READ () {0x16;}' unless defined(&USB_REQ_LOOPBACK_DATA_READ);
    eval 'sub USB_REQ_SET_INTERFACE_DS () {0x17;}' unless defined(&USB_REQ_SET_INTERFACE_DS);
    eval 'sub USB_DEVICE_SELF_POWERED () {0;}' unless defined(&USB_DEVICE_SELF_POWERED);
    eval 'sub USB_DEVICE_REMOTE_WAKEUP () {1;}' unless defined(&USB_DEVICE_REMOTE_WAKEUP);
    eval 'sub USB_DEVICE_TEST_MODE () {2;}' unless defined(&USB_DEVICE_TEST_MODE);
    eval 'sub USB_DEVICE_BATTERY () {2;}' unless defined(&USB_DEVICE_BATTERY);
    eval 'sub USB_DEVICE_B_HNP_ENABLE () {3;}' unless defined(&USB_DEVICE_B_HNP_ENABLE);
    eval 'sub USB_DEVICE_WUSB_DEVICE () {3;}' unless defined(&USB_DEVICE_WUSB_DEVICE);
    eval 'sub USB_DEVICE_A_HNP_SUPPORT () {4;}' unless defined(&USB_DEVICE_A_HNP_SUPPORT);
    eval 'sub USB_DEVICE_A_ALT_HNP_SUPPORT () {5;}' unless defined(&USB_DEVICE_A_ALT_HNP_SUPPORT);
    eval 'sub USB_DEVICE_DEBUG_MODE () {6;}' unless defined(&USB_DEVICE_DEBUG_MODE);
    eval 'sub TEST_J () {1;}' unless defined(&TEST_J);
    eval 'sub TEST_K () {2;}' unless defined(&TEST_K);
    eval 'sub TEST_SE0_NAK () {3;}' unless defined(&TEST_SE0_NAK);
    eval 'sub TEST_PACKET () {4;}' unless defined(&TEST_PACKET);
    eval 'sub TEST_FORCE_EN () {5;}' unless defined(&TEST_FORCE_EN);
    eval 'sub USB_DEVICE_U1_ENABLE () {48;}' unless defined(&USB_DEVICE_U1_ENABLE);
    eval 'sub USB_DEVICE_U2_ENABLE () {49;}' unless defined(&USB_DEVICE_U2_ENABLE);
    eval 'sub USB_DEVICE_LTM_ENABLE () {50;}' unless defined(&USB_DEVICE_LTM_ENABLE);
    eval 'sub USB_INTRF_FUNC_SUSPEND () {0;}' unless defined(&USB_INTRF_FUNC_SUSPEND);
    eval 'sub USB_INTR_FUNC_SUSPEND_OPT_MASK () {0xff00;}' unless defined(&USB_INTR_FUNC_SUSPEND_OPT_MASK);
    eval 'sub USB_INTRF_FUNC_SUSPEND_LP () {(1<< (8+ 0));}' unless defined(&USB_INTRF_FUNC_SUSPEND_LP);
    eval 'sub USB_INTRF_FUNC_SUSPEND_RW () {(1<< (8+ 1));}' unless defined(&USB_INTRF_FUNC_SUSPEND_RW);
    eval 'sub USB_ENDPOINT_HALT () {0;}' unless defined(&USB_ENDPOINT_HALT);
    eval 'sub USB_DEV_STAT_U1_ENABLED () {2;}' unless defined(&USB_DEV_STAT_U1_ENABLED);
    eval 'sub USB_DEV_STAT_U2_ENABLED () {3;}' unless defined(&USB_DEV_STAT_U2_ENABLED);
    eval 'sub USB_DEV_STAT_LTM_ENABLED () {4;}' unless defined(&USB_DEV_STAT_LTM_ENABLED);
    eval 'sub USB_DT_DEVICE () {0x1;}' unless defined(&USB_DT_DEVICE);
    eval 'sub USB_DT_CONFIG () {0x2;}' unless defined(&USB_DT_CONFIG);
    eval 'sub USB_DT_STRING () {0x3;}' unless defined(&USB_DT_STRING);
    eval 'sub USB_DT_INTERFACE () {0x4;}' unless defined(&USB_DT_INTERFACE);
    eval 'sub USB_DT_ENDPOINT () {0x5;}' unless defined(&USB_DT_ENDPOINT);
    eval 'sub USB_DT_DEVICE_QUALIFIER () {0x6;}' unless defined(&USB_DT_DEVICE_QUALIFIER);
    eval 'sub USB_DT_OTHER_SPEED_CONFIG () {0x7;}' unless defined(&USB_DT_OTHER_SPEED_CONFIG);
    eval 'sub USB_DT_INTERFACE_POWER () {0x8;}' unless defined(&USB_DT_INTERFACE_POWER);
    eval 'sub USB_DT_OTG () {0x9;}' unless defined(&USB_DT_OTG);
    eval 'sub USB_DT_DEBUG () {0xa;}' unless defined(&USB_DT_DEBUG);
    eval 'sub USB_DT_INTERFACE_ASSOCIATION () {0xb;}' unless defined(&USB_DT_INTERFACE_ASSOCIATION);
    eval 'sub USB_DT_SECURITY () {0xc;}' unless defined(&USB_DT_SECURITY);
    eval 'sub USB_DT_KEY () {0xd;}' unless defined(&USB_DT_KEY);
    eval 'sub USB_DT_ENCRYPTION_TYPE () {0xe;}' unless defined(&USB_DT_ENCRYPTION_TYPE);
    eval 'sub USB_DT_BOS () {0xf;}' unless defined(&USB_DT_BOS);
    eval 'sub USB_DT_DEVICE_CAPABILITY () {0x10;}' unless defined(&USB_DT_DEVICE_CAPABILITY);
    eval 'sub USB_DT_WIRELESS_ENDPOINT_COMP () {0x11;}' unless defined(&USB_DT_WIRELESS_ENDPOINT_COMP);
    eval 'sub USB_DT_WIRE_ADAPTER () {0x21;}' unless defined(&USB_DT_WIRE_ADAPTER);
    eval 'sub USB_DT_RPIPE () {0x22;}' unless defined(&USB_DT_RPIPE);
    eval 'sub USB_DT_CS_RADIO_CONTROL () {0x23;}' unless defined(&USB_DT_CS_RADIO_CONTROL);
    eval 'sub USB_DT_PIPE_USAGE () {0x24;}' unless defined(&USB_DT_PIPE_USAGE);
    eval 'sub USB_DT_SS_ENDPOINT_COMP () {0x30;}' unless defined(&USB_DT_SS_ENDPOINT_COMP);
    eval 'sub USB_DT_CS_DEVICE () {( &USB_TYPE_CLASS |  &USB_DT_DEVICE);}' unless defined(&USB_DT_CS_DEVICE);
    eval 'sub USB_DT_CS_CONFIG () {( &USB_TYPE_CLASS |  &USB_DT_CONFIG);}' unless defined(&USB_DT_CS_CONFIG);
    eval 'sub USB_DT_CS_STRING () {( &USB_TYPE_CLASS |  &USB_DT_STRING);}' unless defined(&USB_DT_CS_STRING);
    eval 'sub USB_DT_CS_INTERFACE () {( &USB_TYPE_CLASS |  &USB_DT_INTERFACE);}' unless defined(&USB_DT_CS_INTERFACE);
    eval 'sub USB_DT_CS_ENDPOINT () {( &USB_TYPE_CLASS |  &USB_DT_ENDPOINT);}' unless defined(&USB_DT_CS_ENDPOINT);
    eval 'sub USB_DT_DEVICE_SIZE () {18;}' unless defined(&USB_DT_DEVICE_SIZE);
    eval 'sub USB_CLASS_PER_INTERFACE () {0;}' unless defined(&USB_CLASS_PER_INTERFACE);
    eval 'sub USB_CLASS_AUDIO () {1;}' unless defined(&USB_CLASS_AUDIO);
    eval 'sub USB_CLASS_COMM () {2;}' unless defined(&USB_CLASS_COMM);
    eval 'sub USB_CLASS_HID () {3;}' unless defined(&USB_CLASS_HID);
    eval 'sub USB_CLASS_PHYSICAL () {5;}' unless defined(&USB_CLASS_PHYSICAL);
    eval 'sub USB_CLASS_STILL_IMAGE () {6;}' unless defined(&USB_CLASS_STILL_IMAGE);
    eval 'sub USB_CLASS_PRINTER () {7;}' unless defined(&USB_CLASS_PRINTER);
    eval 'sub USB_CLASS_MASS_STORAGE () {8;}' unless defined(&USB_CLASS_MASS_STORAGE);
    eval 'sub USB_CLASS_HUB () {9;}' unless defined(&USB_CLASS_HUB);
    eval 'sub USB_CLASS_CDC_DATA () {0xa;}' unless defined(&USB_CLASS_CDC_DATA);
    eval 'sub USB_CLASS_CSCID () {0xb;}' unless defined(&USB_CLASS_CSCID);
    eval 'sub USB_CLASS_CONTENT_SEC () {0xd;}' unless defined(&USB_CLASS_CONTENT_SEC);
    eval 'sub USB_CLASS_VIDEO () {0xe;}' unless defined(&USB_CLASS_VIDEO);
    eval 'sub USB_CLASS_WIRELESS_CONTROLLER () {0xe0;}' unless defined(&USB_CLASS_WIRELESS_CONTROLLER);
    eval 'sub USB_CLASS_MISC () {0xef;}' unless defined(&USB_CLASS_MISC);
    eval 'sub USB_CLASS_APP_SPEC () {0xfe;}' unless defined(&USB_CLASS_APP_SPEC);
    eval 'sub USB_CLASS_VENDOR_SPEC () {0xff;}' unless defined(&USB_CLASS_VENDOR_SPEC);
    eval 'sub USB_SUBCLASS_VENDOR_SPEC () {0xff;}' unless defined(&USB_SUBCLASS_VENDOR_SPEC);
    eval 'sub USB_DT_CONFIG_SIZE () {9;}' unless defined(&USB_DT_CONFIG_SIZE);
    eval 'sub USB_CONFIG_ATT_ONE () {(1<< 7);}' unless defined(&USB_CONFIG_ATT_ONE);
    eval 'sub USB_CONFIG_ATT_SELFPOWER () {(1<< 6);}' unless defined(&USB_CONFIG_ATT_SELFPOWER);
    eval 'sub USB_CONFIG_ATT_WAKEUP () {(1<< 5);}' unless defined(&USB_CONFIG_ATT_WAKEUP);
    eval 'sub USB_CONFIG_ATT_BATTERY () {(1<< 4);}' unless defined(&USB_CONFIG_ATT_BATTERY);
    eval 'sub USB_DT_INTERFACE_SIZE () {9;}' unless defined(&USB_DT_INTERFACE_SIZE);
    eval 'sub USB_DT_ENDPOINT_SIZE () {7;}' unless defined(&USB_DT_ENDPOINT_SIZE);
    eval 'sub USB_DT_ENDPOINT_AUDIO_SIZE () {9;}' unless defined(&USB_DT_ENDPOINT_AUDIO_SIZE);
    eval 'sub USB_ENDPOINT_NUMBER_MASK () {0xf;}' unless defined(&USB_ENDPOINT_NUMBER_MASK);
    eval 'sub USB_ENDPOINT_DIR_MASK () {0x80;}' unless defined(&USB_ENDPOINT_DIR_MASK);
    eval 'sub USB_ENDPOINT_XFERTYPE_MASK () {0x3;}' unless defined(&USB_ENDPOINT_XFERTYPE_MASK);
    eval 'sub USB_ENDPOINT_XFER_CONTROL () {0;}' unless defined(&USB_ENDPOINT_XFER_CONTROL);
    eval 'sub USB_ENDPOINT_XFER_ISOC () {1;}' unless defined(&USB_ENDPOINT_XFER_ISOC);
    eval 'sub USB_ENDPOINT_XFER_BULK () {2;}' unless defined(&USB_ENDPOINT_XFER_BULK);
    eval 'sub USB_ENDPOINT_XFER_INT () {3;}' unless defined(&USB_ENDPOINT_XFER_INT);
    eval 'sub USB_ENDPOINT_MAX_ADJUSTABLE () {0x80;}' unless defined(&USB_ENDPOINT_MAX_ADJUSTABLE);
    eval 'sub USB_ENDPOINT_INTRTYPE () {0x30;}' unless defined(&USB_ENDPOINT_INTRTYPE);
    eval 'sub USB_ENDPOINT_INTR_PERIODIC () {(0<< 4);}' unless defined(&USB_ENDPOINT_INTR_PERIODIC);
    eval 'sub USB_ENDPOINT_INTR_NOTIFICATION () {(1<< 4);}' unless defined(&USB_ENDPOINT_INTR_NOTIFICATION);
    eval 'sub USB_ENDPOINT_SYNCTYPE () {0xc;}' unless defined(&USB_ENDPOINT_SYNCTYPE);
    eval 'sub USB_ENDPOINT_SYNC_NONE () {(0<< 2);}' unless defined(&USB_ENDPOINT_SYNC_NONE);
    eval 'sub USB_ENDPOINT_SYNC_ASYNC () {(1<< 2);}' unless defined(&USB_ENDPOINT_SYNC_ASYNC);
    eval 'sub USB_ENDPOINT_SYNC_ADAPTIVE () {(2<< 2);}' unless defined(&USB_ENDPOINT_SYNC_ADAPTIVE);
    eval 'sub USB_ENDPOINT_SYNC_SYNC () {(3<< 2);}' unless defined(&USB_ENDPOINT_SYNC_SYNC);
    eval 'sub USB_ENDPOINT_USAGE_MASK () {0x30;}' unless defined(&USB_ENDPOINT_USAGE_MASK);
    eval 'sub USB_ENDPOINT_USAGE_DATA () {0x;}' unless defined(&USB_ENDPOINT_USAGE_DATA);
    eval 'sub USB_ENDPOINT_USAGE_FEEDBACK () {0x10;}' unless defined(&USB_ENDPOINT_USAGE_FEEDBACK);
    eval 'sub USB_ENDPOINT_USAGE_IMPLICIT_FB () {0x20;}' unless defined(&USB_ENDPOINT_USAGE_IMPLICIT_FB);
    eval 'sub usb_endpoint_interrupt_type {
        my($epd) = @_;
	    eval q({  ($epd->{bmAttributes}) &  &USB_ENDPOINT_INTRTYPE; });
    }' unless defined(&usb_endpoint_interrupt_type);
    eval 'sub USB_DT_SS_EP_COMP_SIZE () {6;}' unless defined(&USB_DT_SS_EP_COMP_SIZE);
    eval 'sub USB_SS_MULT {
        my($p) = @_;
	    eval q((1+ (($p) & 0x3)));
    }' unless defined(&USB_SS_MULT);
    eval 'sub USB_OTG_SRP () {(1<< 0);}' unless defined(&USB_OTG_SRP);
    eval 'sub USB_OTG_HNP () {(1<< 1);}' unless defined(&USB_OTG_HNP);
    eval 'sub USB_ENC_TYPE_UNSECURE () {0;}' unless defined(&USB_ENC_TYPE_UNSECURE);
    eval 'sub USB_ENC_TYPE_WIRED () {1;}' unless defined(&USB_ENC_TYPE_WIRED);
    eval 'sub USB_ENC_TYPE_CCM_1 () {2;}' unless defined(&USB_ENC_TYPE_CCM_1);
    eval 'sub USB_ENC_TYPE_RSA_1 () {3;}' unless defined(&USB_ENC_TYPE_RSA_1);
    eval 'sub USB_DT_BOS_SIZE () {5;}' unless defined(&USB_DT_BOS_SIZE);
    eval 'sub USB_CAP_TYPE_WIRELESS_USB () {1;}' unless defined(&USB_CAP_TYPE_WIRELESS_USB);
    eval 'sub USB_WIRELESS_P2P_DRD () {(1<< 1);}' unless defined(&USB_WIRELESS_P2P_DRD);
    eval 'sub USB_WIRELESS_BEACON_MASK () {(3<< 2);}' unless defined(&USB_WIRELESS_BEACON_MASK);
    eval 'sub USB_WIRELESS_BEACON_SELF () {(1<< 2);}' unless defined(&USB_WIRELESS_BEACON_SELF);
    eval 'sub USB_WIRELESS_BEACON_DIRECTED () {(2<< 2);}' unless defined(&USB_WIRELESS_BEACON_DIRECTED);
    eval 'sub USB_WIRELESS_BEACON_NONE () {(3<< 2);}' unless defined(&USB_WIRELESS_BEACON_NONE);
    eval 'sub USB_WIRELESS_PHY_53 () {(1<< 0);}' unless defined(&USB_WIRELESS_PHY_53);
    eval 'sub USB_WIRELESS_PHY_80 () {(1<< 1);}' unless defined(&USB_WIRELESS_PHY_80);
    eval 'sub USB_WIRELESS_PHY_107 () {(1<< 2);}' unless defined(&USB_WIRELESS_PHY_107);
    eval 'sub USB_WIRELESS_PHY_160 () {(1<< 3);}' unless defined(&USB_WIRELESS_PHY_160);
    eval 'sub USB_WIRELESS_PHY_200 () {(1<< 4);}' unless defined(&USB_WIRELESS_PHY_200);
    eval 'sub USB_WIRELESS_PHY_320 () {(1<< 5);}' unless defined(&USB_WIRELESS_PHY_320);
    eval 'sub USB_WIRELESS_PHY_400 () {(1<< 6);}' unless defined(&USB_WIRELESS_PHY_400);
    eval 'sub USB_WIRELESS_PHY_480 () {(1<< 7);}' unless defined(&USB_WIRELESS_PHY_480);
    eval 'sub USB_CAP_TYPE_EXT () {2;}' unless defined(&USB_CAP_TYPE_EXT);
    eval 'sub USB_LPM_SUPPORT () {(1<< 1);}' unless defined(&USB_LPM_SUPPORT);
    eval 'sub USB_BESL_SUPPORT () {(1<< 2);}' unless defined(&USB_BESL_SUPPORT);
    eval 'sub USB_BESL_BASELINE_VALID () {(1<< 3);}' unless defined(&USB_BESL_BASELINE_VALID);
    eval 'sub USB_BESL_DEEP_VALID () {(1<< 4);}' unless defined(&USB_BESL_DEEP_VALID);
    eval 'sub USB_GET_BESL_BASELINE {
        my($p) = @_;
	    eval q(((($p) & (0xf << 8)) >> 8));
    }' unless defined(&USB_GET_BESL_BASELINE);
    eval 'sub USB_GET_BESL_DEEP {
        my($p) = @_;
	    eval q(((($p) & (0xf << 12)) >> 12));
    }' unless defined(&USB_GET_BESL_DEEP);
    eval 'sub USB_DT_USB_EXT_CAP_SIZE () {7;}' unless defined(&USB_DT_USB_EXT_CAP_SIZE);
    eval 'sub USB_SS_CAP_TYPE () {3;}' unless defined(&USB_SS_CAP_TYPE);
    eval 'sub USB_LTM_SUPPORT () {(1<< 1);}' unless defined(&USB_LTM_SUPPORT);
    eval 'sub USB_LOW_SPEED_OPERATION () {(1);}' unless defined(&USB_LOW_SPEED_OPERATION);
    eval 'sub USB_FULL_SPEED_OPERATION () {(1<< 1);}' unless defined(&USB_FULL_SPEED_OPERATION);
    eval 'sub USB_HIGH_SPEED_OPERATION () {(1<< 2);}' unless defined(&USB_HIGH_SPEED_OPERATION);
    eval 'sub USB_5GBPS_OPERATION () {(1<< 3);}' unless defined(&USB_5GBPS_OPERATION);
    eval 'sub USB_DT_USB_SS_CAP_SIZE () {10;}' unless defined(&USB_DT_USB_SS_CAP_SIZE);
    eval 'sub CONTAINER_ID_TYPE () {4;}' unless defined(&CONTAINER_ID_TYPE);
    eval 'sub USB_DT_USB_SS_CONTN_ID_SIZE () {20;}' unless defined(&USB_DT_USB_SS_CONTN_ID_SIZE);
    eval 'sub USB_ENDPOINT_SWITCH_MASK () {0x3;}' unless defined(&USB_ENDPOINT_SWITCH_MASK);
    eval 'sub USB_ENDPOINT_SWITCH_NO () {0;}' unless defined(&USB_ENDPOINT_SWITCH_NO);
    eval 'sub USB_ENDPOINT_SWITCH_SWITCH () {1;}' unless defined(&USB_ENDPOINT_SWITCH_SWITCH);
    eval 'sub USB_ENDPOINT_SWITCH_SCALE () {2;}' unless defined(&USB_ENDPOINT_SWITCH_SCALE);
    eval("sub USB_SPEED_UNKNOWN () { 0; }") unless defined(&USB_SPEED_UNKNOWN);
    eval("sub USB_SPEED_LOW () { 1; }") unless defined(&USB_SPEED_LOW);
    eval("sub USB_SPEED_FULL () { 2; }") unless defined(&USB_SPEED_FULL);
    eval("sub USB_SPEED_HIGH () { 3; }") unless defined(&USB_SPEED_HIGH);
    eval("sub USB_SPEED_WIRELESS () { 4; }") unless defined(&USB_SPEED_WIRELESS);
    eval("sub USB_SPEED_SUPER () { 5; }") unless defined(&USB_SPEED_SUPER);
    eval("sub USB_STATE_NOTATTACHED () { 0; }") unless defined(&USB_STATE_NOTATTACHED);
    eval("sub USB_STATE_ATTACHED () { 1; }") unless defined(&USB_STATE_ATTACHED);
    eval("sub USB_STATE_POWERED () { 2; }") unless defined(&USB_STATE_POWERED);
    eval("sub USB_STATE_RECONNECTING () { 3; }") unless defined(&USB_STATE_RECONNECTING);
    eval("sub USB_STATE_UNAUTHENTICATED () { 4; }") unless defined(&USB_STATE_UNAUTHENTICATED);
    eval("sub USB_STATE_DEFAULT () { 5; }") unless defined(&USB_STATE_DEFAULT);
    eval("sub USB_STATE_ADDRESS () { 6; }") unless defined(&USB_STATE_ADDRESS);
    eval("sub USB_STATE_CONFIGURED () { 7; }") unless defined(&USB_STATE_CONFIGURED);
    eval("sub USB_STATE_SUSPENDED () { 8; }") unless defined(&USB_STATE_SUSPENDED);
    eval("sub USB3_LPM_U0 () { 0; }") unless defined(&USB3_LPM_U0);
    eval("sub USB3_LPM_U1 () { 1; }") unless defined(&USB3_LPM_U1);
    eval("sub USB3_LPM_U2 () { 2; }") unless defined(&USB3_LPM_U2);
    eval("sub USB3_LPM_U3 () { 3; }") unless defined(&USB3_LPM_U3);
    eval 'sub USB3_LPM_DISABLED () {0x;}' unless defined(&USB3_LPM_DISABLED);
    eval 'sub USB3_LPM_U1_MAX_TIMEOUT () {0x7f;}' unless defined(&USB3_LPM_U1_MAX_TIMEOUT);
    eval 'sub USB3_LPM_U2_MAX_TIMEOUT () {0xfe;}' unless defined(&USB3_LPM_U2_MAX_TIMEOUT);
    eval 'sub USB3_LPM_DEVICE_INITIATED () {0xff;}' unless defined(&USB3_LPM_DEVICE_INITIATED);
    eval 'sub USB3_LPM_MAX_U1_SEL_PEL () {0xff;}' unless defined(&USB3_LPM_MAX_U1_SEL_PEL);
    eval 'sub USB3_LPM_MAX_U2_SEL_PEL () {0xffff;}' unless defined(&USB3_LPM_MAX_U2_SEL_PEL);
    eval 'sub USB_SELF_POWER_VBUS_MAX_DRAW () {100;}' unless defined(&USB_SELF_POWER_VBUS_MAX_DRAW);
}
1;
