require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ASM_X86_MSR_INDEX_H)) {
    eval 'sub _ASM_X86_MSR_INDEX_H () {1;}' unless defined(&_ASM_X86_MSR_INDEX_H);
    eval 'sub MSR_EFER () {0xc0000080;}' unless defined(&MSR_EFER);
    eval 'sub MSR_STAR () {0xc0000081;}' unless defined(&MSR_STAR);
    eval 'sub MSR_LSTAR () {0xc0000082;}' unless defined(&MSR_LSTAR);
    eval 'sub MSR_CSTAR () {0xc0000083;}' unless defined(&MSR_CSTAR);
    eval 'sub MSR_SYSCALL_MASK () {0xc0000084;}' unless defined(&MSR_SYSCALL_MASK);
    eval 'sub MSR_FS_BASE () {0xc0000100;}' unless defined(&MSR_FS_BASE);
    eval 'sub MSR_GS_BASE () {0xc0000101;}' unless defined(&MSR_GS_BASE);
    eval 'sub MSR_KERNEL_GS_BASE () {0xc0000102;}' unless defined(&MSR_KERNEL_GS_BASE);
    eval 'sub MSR_TSC_AUX () {0xc0000103;}' unless defined(&MSR_TSC_AUX);
    eval 'sub _EFER_SCE () {0;}' unless defined(&_EFER_SCE);
    eval 'sub _EFER_LME () {8;}' unless defined(&_EFER_LME);
    eval 'sub _EFER_LMA () {10;}' unless defined(&_EFER_LMA);
    eval 'sub _EFER_NX () {11;}' unless defined(&_EFER_NX);
    eval 'sub _EFER_SVME () {12;}' unless defined(&_EFER_SVME);
    eval 'sub _EFER_LMSLE () {13;}' unless defined(&_EFER_LMSLE);
    eval 'sub _EFER_FFXSR () {14;}' unless defined(&_EFER_FFXSR);
    eval 'sub EFER_SCE () {(1<< &_EFER_SCE);}' unless defined(&EFER_SCE);
    eval 'sub EFER_LME () {(1<< &_EFER_LME);}' unless defined(&EFER_LME);
    eval 'sub EFER_LMA () {(1<< &_EFER_LMA);}' unless defined(&EFER_LMA);
    eval 'sub EFER_NX () {(1<< &_EFER_NX);}' unless defined(&EFER_NX);
    eval 'sub EFER_SVME () {(1<< &_EFER_SVME);}' unless defined(&EFER_SVME);
    eval 'sub EFER_LMSLE () {(1<< &_EFER_LMSLE);}' unless defined(&EFER_LMSLE);
    eval 'sub EFER_FFXSR () {(1<< &_EFER_FFXSR);}' unless defined(&EFER_FFXSR);
    eval 'sub MSR_IA32_PERFCTR0 () {0xc1;}' unless defined(&MSR_IA32_PERFCTR0);
    eval 'sub MSR_IA32_PERFCTR1 () {0xc2;}' unless defined(&MSR_IA32_PERFCTR1);
    eval 'sub MSR_FSB_FREQ () {0xcd;}' unless defined(&MSR_FSB_FREQ);
    eval 'sub MSR_NHM_SNB_PKG_CST_CFG_CTL () {0xe2;}' unless defined(&MSR_NHM_SNB_PKG_CST_CFG_CTL);
    eval 'sub NHM_C3_AUTO_DEMOTE () {(1 << 25);}' unless defined(&NHM_C3_AUTO_DEMOTE);
    eval 'sub NHM_C1_AUTO_DEMOTE () {(1 << 26);}' unless defined(&NHM_C1_AUTO_DEMOTE);
    eval 'sub ATM_LNC_C6_AUTO_DEMOTE () {(1 << 25);}' unless defined(&ATM_LNC_C6_AUTO_DEMOTE);
    eval 'sub MSR_MTRRcap () {0xfe;}' unless defined(&MSR_MTRRcap);
    eval 'sub MSR_IA32_BBL_CR_CTL () {0x119;}' unless defined(&MSR_IA32_BBL_CR_CTL);
    eval 'sub MSR_IA32_BBL_CR_CTL3 () {0x11e;}' unless defined(&MSR_IA32_BBL_CR_CTL3);
    eval 'sub MSR_IA32_SYSENTER_CS () {0x174;}' unless defined(&MSR_IA32_SYSENTER_CS);
    eval 'sub MSR_IA32_SYSENTER_ESP () {0x175;}' unless defined(&MSR_IA32_SYSENTER_ESP);
    eval 'sub MSR_IA32_SYSENTER_EIP () {0x176;}' unless defined(&MSR_IA32_SYSENTER_EIP);
    eval 'sub MSR_IA32_MCG_CAP () {0x179;}' unless defined(&MSR_IA32_MCG_CAP);
    eval 'sub MSR_IA32_MCG_STATUS () {0x17a;}' unless defined(&MSR_IA32_MCG_STATUS);
    eval 'sub MSR_IA32_MCG_CTL () {0x17b;}' unless defined(&MSR_IA32_MCG_CTL);
    eval 'sub MSR_OFFCORE_RSP_0 () {0x1a6;}' unless defined(&MSR_OFFCORE_RSP_0);
    eval 'sub MSR_OFFCORE_RSP_1 () {0x1a7;}' unless defined(&MSR_OFFCORE_RSP_1);
    eval 'sub MSR_LBR_SELECT () {0x1c8;}' unless defined(&MSR_LBR_SELECT);
    eval 'sub MSR_LBR_TOS () {0x1c9;}' unless defined(&MSR_LBR_TOS);
    eval 'sub MSR_LBR_NHM_FROM () {0x680;}' unless defined(&MSR_LBR_NHM_FROM);
    eval 'sub MSR_LBR_NHM_TO () {0x6c0;}' unless defined(&MSR_LBR_NHM_TO);
    eval 'sub MSR_LBR_CORE_FROM () {0x40;}' unless defined(&MSR_LBR_CORE_FROM);
    eval 'sub MSR_LBR_CORE_TO () {0x60;}' unless defined(&MSR_LBR_CORE_TO);
    eval 'sub MSR_IA32_PEBS_ENABLE () {0x3f1;}' unless defined(&MSR_IA32_PEBS_ENABLE);
    eval 'sub MSR_IA32_DS_AREA () {0x600;}' unless defined(&MSR_IA32_DS_AREA);
    eval 'sub MSR_IA32_PERF_CAPABILITIES () {0x345;}' unless defined(&MSR_IA32_PERF_CAPABILITIES);
    eval 'sub MSR_MTRRfix64K_00000 () {0x250;}' unless defined(&MSR_MTRRfix64K_00000);
    eval 'sub MSR_MTRRfix16K_80000 () {0x258;}' unless defined(&MSR_MTRRfix16K_80000);
    eval 'sub MSR_MTRRfix16K_A0000 () {0x259;}' unless defined(&MSR_MTRRfix16K_A0000);
    eval 'sub MSR_MTRRfix4K_C0000 () {0x268;}' unless defined(&MSR_MTRRfix4K_C0000);
    eval 'sub MSR_MTRRfix4K_C8000 () {0x269;}' unless defined(&MSR_MTRRfix4K_C8000);
    eval 'sub MSR_MTRRfix4K_D0000 () {0x26a;}' unless defined(&MSR_MTRRfix4K_D0000);
    eval 'sub MSR_MTRRfix4K_D8000 () {0x26b;}' unless defined(&MSR_MTRRfix4K_D8000);
    eval 'sub MSR_MTRRfix4K_E0000 () {0x26c;}' unless defined(&MSR_MTRRfix4K_E0000);
    eval 'sub MSR_MTRRfix4K_E8000 () {0x26d;}' unless defined(&MSR_MTRRfix4K_E8000);
    eval 'sub MSR_MTRRfix4K_F0000 () {0x26e;}' unless defined(&MSR_MTRRfix4K_F0000);
    eval 'sub MSR_MTRRfix4K_F8000 () {0x26f;}' unless defined(&MSR_MTRRfix4K_F8000);
    eval 'sub MSR_MTRRdefType () {0x2ff;}' unless defined(&MSR_MTRRdefType);
    eval 'sub MSR_IA32_CR_PAT () {0x277;}' unless defined(&MSR_IA32_CR_PAT);
    eval 'sub MSR_IA32_DEBUGCTLMSR () {0x1d9;}' unless defined(&MSR_IA32_DEBUGCTLMSR);
    eval 'sub MSR_IA32_LASTBRANCHFROMIP () {0x1db;}' unless defined(&MSR_IA32_LASTBRANCHFROMIP);
    eval 'sub MSR_IA32_LASTBRANCHTOIP () {0x1dc;}' unless defined(&MSR_IA32_LASTBRANCHTOIP);
    eval 'sub MSR_IA32_LASTINTFROMIP () {0x1dd;}' unless defined(&MSR_IA32_LASTINTFROMIP);
    eval 'sub MSR_IA32_LASTINTTOIP () {0x1de;}' unless defined(&MSR_IA32_LASTINTTOIP);
    eval 'sub DEBUGCTLMSR_LBR () {(1 << 0);}' unless defined(&DEBUGCTLMSR_LBR);
    eval 'sub DEBUGCTLMSR_BTF () {(1 << 1);}' unless defined(&DEBUGCTLMSR_BTF);
    eval 'sub DEBUGCTLMSR_TR () {(1 << 6);}' unless defined(&DEBUGCTLMSR_TR);
    eval 'sub DEBUGCTLMSR_BTS () {(1 << 7);}' unless defined(&DEBUGCTLMSR_BTS);
    eval 'sub DEBUGCTLMSR_BTINT () {(1 << 8);}' unless defined(&DEBUGCTLMSR_BTINT);
    eval 'sub DEBUGCTLMSR_BTS_OFF_OS () {(1 << 9);}' unless defined(&DEBUGCTLMSR_BTS_OFF_OS);
    eval 'sub DEBUGCTLMSR_BTS_OFF_USR () {(1 << 10);}' unless defined(&DEBUGCTLMSR_BTS_OFF_USR);
    eval 'sub DEBUGCTLMSR_FREEZE_LBRS_ON_PMI () {(1 << 11);}' unless defined(&DEBUGCTLMSR_FREEZE_LBRS_ON_PMI);
    eval 'sub MSR_IA32_MC0_CTL () {0x400;}' unless defined(&MSR_IA32_MC0_CTL);
    eval 'sub MSR_IA32_MC0_STATUS () {0x401;}' unless defined(&MSR_IA32_MC0_STATUS);
    eval 'sub MSR_IA32_MC0_ADDR () {0x402;}' unless defined(&MSR_IA32_MC0_ADDR);
    eval 'sub MSR_IA32_MC0_MISC () {0x403;}' unless defined(&MSR_IA32_MC0_MISC);
    eval 'sub MSR_AMD64_MC0_MASK () {0xc0010044;}' unless defined(&MSR_AMD64_MC0_MASK);
    eval 'sub MSR_IA32_MCx_CTL {
        my($x) = @_;
	    eval q(( &MSR_IA32_MC0_CTL + 4*($x)));
    }' unless defined(&MSR_IA32_MCx_CTL);
    eval 'sub MSR_IA32_MCx_STATUS {
        my($x) = @_;
	    eval q(( &MSR_IA32_MC0_STATUS + 4*($x)));
    }' unless defined(&MSR_IA32_MCx_STATUS);
    eval 'sub MSR_IA32_MCx_ADDR {
        my($x) = @_;
	    eval q(( &MSR_IA32_MC0_ADDR + 4*($x)));
    }' unless defined(&MSR_IA32_MCx_ADDR);
    eval 'sub MSR_IA32_MCx_MISC {
        my($x) = @_;
	    eval q(( &MSR_IA32_MC0_MISC + 4*($x)));
    }' unless defined(&MSR_IA32_MCx_MISC);
    eval 'sub MSR_AMD64_MCx_MASK {
        my($x) = @_;
	    eval q(( &MSR_AMD64_MC0_MASK + ($x)));
    }' unless defined(&MSR_AMD64_MCx_MASK);
    eval 'sub MSR_IA32_MC0_CTL2 () {0x280;}' unless defined(&MSR_IA32_MC0_CTL2);
    eval 'sub MSR_IA32_MCx_CTL2 {
        my($x) = @_;
	    eval q(( &MSR_IA32_MC0_CTL2 + ($x)));
    }' unless defined(&MSR_IA32_MCx_CTL2);
    eval 'sub MSR_P6_PERFCTR0 () {0xc1;}' unless defined(&MSR_P6_PERFCTR0);
    eval 'sub MSR_P6_PERFCTR1 () {0xc2;}' unless defined(&MSR_P6_PERFCTR1);
    eval 'sub MSR_P6_EVNTSEL0 () {0x186;}' unless defined(&MSR_P6_EVNTSEL0);
    eval 'sub MSR_P6_EVNTSEL1 () {0x187;}' unless defined(&MSR_P6_EVNTSEL1);
    eval 'sub MSR_AMD64_PATCH_LEVEL () {0x8b;}' unless defined(&MSR_AMD64_PATCH_LEVEL);
    eval 'sub MSR_AMD64_TSC_RATIO () {0xc0000104;}' unless defined(&MSR_AMD64_TSC_RATIO);
    eval 'sub MSR_AMD64_NB_CFG () {0xc001001f;}' unless defined(&MSR_AMD64_NB_CFG);
    eval 'sub MSR_AMD64_PATCH_LOADER () {0xc0010020;}' unless defined(&MSR_AMD64_PATCH_LOADER);
    eval 'sub MSR_AMD64_OSVW_ID_LENGTH () {0xc0010140;}' unless defined(&MSR_AMD64_OSVW_ID_LENGTH);
    eval 'sub MSR_AMD64_OSVW_STATUS () {0xc0010141;}' unless defined(&MSR_AMD64_OSVW_STATUS);
    eval 'sub MSR_AMD64_DC_CFG () {0xc0011022;}' unless defined(&MSR_AMD64_DC_CFG);
    eval 'sub MSR_AMD64_IBSFETCHCTL () {0xc0011030;}' unless defined(&MSR_AMD64_IBSFETCHCTL);
    eval 'sub MSR_AMD64_IBSFETCHLINAD () {0xc0011031;}' unless defined(&MSR_AMD64_IBSFETCHLINAD);
    eval 'sub MSR_AMD64_IBSFETCHPHYSAD () {0xc0011032;}' unless defined(&MSR_AMD64_IBSFETCHPHYSAD);
    eval 'sub MSR_AMD64_IBSOPCTL () {0xc0011033;}' unless defined(&MSR_AMD64_IBSOPCTL);
    eval 'sub MSR_AMD64_IBSOPRIP () {0xc0011034;}' unless defined(&MSR_AMD64_IBSOPRIP);
    eval 'sub MSR_AMD64_IBSOPDATA () {0xc0011035;}' unless defined(&MSR_AMD64_IBSOPDATA);
    eval 'sub MSR_AMD64_IBSOPDATA2 () {0xc0011036;}' unless defined(&MSR_AMD64_IBSOPDATA2);
    eval 'sub MSR_AMD64_IBSOPDATA3 () {0xc0011037;}' unless defined(&MSR_AMD64_IBSOPDATA3);
    eval 'sub MSR_AMD64_IBSDCLINAD () {0xc0011038;}' unless defined(&MSR_AMD64_IBSDCLINAD);
    eval 'sub MSR_AMD64_IBSDCPHYSAD () {0xc0011039;}' unless defined(&MSR_AMD64_IBSDCPHYSAD);
    eval 'sub MSR_AMD64_IBSCTL () {0xc001103a;}' unless defined(&MSR_AMD64_IBSCTL);
    eval 'sub MSR_AMD64_IBSBRTARGET () {0xc001103b;}' unless defined(&MSR_AMD64_IBSBRTARGET);
    eval 'sub MSR_F15H_PERF_CTL () {0xc0010200;}' unless defined(&MSR_F15H_PERF_CTL);
    eval 'sub MSR_F15H_PERF_CTR () {0xc0010201;}' unless defined(&MSR_F15H_PERF_CTR);
    eval 'sub MSR_FAM10H_MMIO_CONF_BASE () {0xc0010058;}' unless defined(&MSR_FAM10H_MMIO_CONF_BASE);
    eval 'sub FAM10H_MMIO_CONF_ENABLE () {(1<<0);}' unless defined(&FAM10H_MMIO_CONF_ENABLE);
    eval 'sub FAM10H_MMIO_CONF_BUSRANGE_MASK () {0xf;}' unless defined(&FAM10H_MMIO_CONF_BUSRANGE_MASK);
    eval 'sub FAM10H_MMIO_CONF_BUSRANGE_SHIFT () {2;}' unless defined(&FAM10H_MMIO_CONF_BUSRANGE_SHIFT);
    eval 'sub FAM10H_MMIO_CONF_BASE_MASK () {0xfffffff;}' unless defined(&FAM10H_MMIO_CONF_BASE_MASK);
    eval 'sub FAM10H_MMIO_CONF_BASE_SHIFT () {20;}' unless defined(&FAM10H_MMIO_CONF_BASE_SHIFT);
    eval 'sub MSR_FAM10H_NODE_ID () {0xc001100c;}' unless defined(&MSR_FAM10H_NODE_ID);
    eval 'sub MSR_K8_TOP_MEM1 () {0xc001001a;}' unless defined(&MSR_K8_TOP_MEM1);
    eval 'sub MSR_K8_TOP_MEM2 () {0xc001001d;}' unless defined(&MSR_K8_TOP_MEM2);
    eval 'sub MSR_K8_SYSCFG () {0xc0010010;}' unless defined(&MSR_K8_SYSCFG);
    eval 'sub MSR_K8_INT_PENDING_MSG () {0xc0010055;}' unless defined(&MSR_K8_INT_PENDING_MSG);
    eval 'sub K8_INTP_C1E_ACTIVE_MASK () {0x18000000;}' unless defined(&K8_INTP_C1E_ACTIVE_MASK);
    eval 'sub MSR_K8_TSEG_ADDR () {0xc0010112;}' unless defined(&MSR_K8_TSEG_ADDR);
    eval 'sub K8_MTRRFIXRANGE_DRAM_ENABLE () {0x40000;}' unless defined(&K8_MTRRFIXRANGE_DRAM_ENABLE);
    eval 'sub K8_MTRRFIXRANGE_DRAM_MODIFY () {0x80000;}' unless defined(&K8_MTRRFIXRANGE_DRAM_MODIFY);
    eval 'sub K8_MTRR_RDMEM_WRMEM_MASK () {0x18181818;}' unless defined(&K8_MTRR_RDMEM_WRMEM_MASK);
    eval 'sub MSR_K7_EVNTSEL0 () {0xc0010000;}' unless defined(&MSR_K7_EVNTSEL0);
    eval 'sub MSR_K7_PERFCTR0 () {0xc0010004;}' unless defined(&MSR_K7_PERFCTR0);
    eval 'sub MSR_K7_EVNTSEL1 () {0xc0010001;}' unless defined(&MSR_K7_EVNTSEL1);
    eval 'sub MSR_K7_PERFCTR1 () {0xc0010005;}' unless defined(&MSR_K7_PERFCTR1);
    eval 'sub MSR_K7_EVNTSEL2 () {0xc0010002;}' unless defined(&MSR_K7_EVNTSEL2);
    eval 'sub MSR_K7_PERFCTR2 () {0xc0010006;}' unless defined(&MSR_K7_PERFCTR2);
    eval 'sub MSR_K7_EVNTSEL3 () {0xc0010003;}' unless defined(&MSR_K7_EVNTSEL3);
    eval 'sub MSR_K7_PERFCTR3 () {0xc0010007;}' unless defined(&MSR_K7_PERFCTR3);
    eval 'sub MSR_K7_CLK_CTL () {0xc001001b;}' unless defined(&MSR_K7_CLK_CTL);
    eval 'sub MSR_K7_HWCR () {0xc0010015;}' unless defined(&MSR_K7_HWCR);
    eval 'sub MSR_K7_FID_VID_CTL () {0xc0010041;}' unless defined(&MSR_K7_FID_VID_CTL);
    eval 'sub MSR_K7_FID_VID_STATUS () {0xc0010042;}' unless defined(&MSR_K7_FID_VID_STATUS);
    eval 'sub MSR_K6_WHCR () {0xc0000082;}' unless defined(&MSR_K6_WHCR);
    eval 'sub MSR_K6_UWCCR () {0xc0000085;}' unless defined(&MSR_K6_UWCCR);
    eval 'sub MSR_K6_EPMR () {0xc0000086;}' unless defined(&MSR_K6_EPMR);
    eval 'sub MSR_K6_PSOR () {0xc0000087;}' unless defined(&MSR_K6_PSOR);
    eval 'sub MSR_K6_PFIR () {0xc0000088;}' unless defined(&MSR_K6_PFIR);
    eval 'sub MSR_IDT_FCR1 () {0x107;}' unless defined(&MSR_IDT_FCR1);
    eval 'sub MSR_IDT_FCR2 () {0x108;}' unless defined(&MSR_IDT_FCR2);
    eval 'sub MSR_IDT_FCR3 () {0x109;}' unless defined(&MSR_IDT_FCR3);
    eval 'sub MSR_IDT_FCR4 () {0x10a;}' unless defined(&MSR_IDT_FCR4);
    eval 'sub MSR_IDT_MCR0 () {0x110;}' unless defined(&MSR_IDT_MCR0);
    eval 'sub MSR_IDT_MCR1 () {0x111;}' unless defined(&MSR_IDT_MCR1);
    eval 'sub MSR_IDT_MCR2 () {0x112;}' unless defined(&MSR_IDT_MCR2);
    eval 'sub MSR_IDT_MCR3 () {0x113;}' unless defined(&MSR_IDT_MCR3);
    eval 'sub MSR_IDT_MCR4 () {0x114;}' unless defined(&MSR_IDT_MCR4);
    eval 'sub MSR_IDT_MCR5 () {0x115;}' unless defined(&MSR_IDT_MCR5);
    eval 'sub MSR_IDT_MCR6 () {0x116;}' unless defined(&MSR_IDT_MCR6);
    eval 'sub MSR_IDT_MCR7 () {0x117;}' unless defined(&MSR_IDT_MCR7);
    eval 'sub MSR_IDT_MCR_CTRL () {0x120;}' unless defined(&MSR_IDT_MCR_CTRL);
    eval 'sub MSR_VIA_FCR () {0x1107;}' unless defined(&MSR_VIA_FCR);
    eval 'sub MSR_VIA_LONGHAUL () {0x110a;}' unless defined(&MSR_VIA_LONGHAUL);
    eval 'sub MSR_VIA_RNG () {0x110b;}' unless defined(&MSR_VIA_RNG);
    eval 'sub MSR_VIA_BCR2 () {0x1147;}' unless defined(&MSR_VIA_BCR2);
    eval 'sub MSR_TMTA_LONGRUN_CTRL () {0x80868010;}' unless defined(&MSR_TMTA_LONGRUN_CTRL);
    eval 'sub MSR_TMTA_LONGRUN_FLAGS () {0x80868011;}' unless defined(&MSR_TMTA_LONGRUN_FLAGS);
    eval 'sub MSR_TMTA_LRTI_READOUT () {0x80868018;}' unless defined(&MSR_TMTA_LRTI_READOUT);
    eval 'sub MSR_TMTA_LRTI_VOLT_MHZ () {0x8086801a;}' unless defined(&MSR_TMTA_LRTI_VOLT_MHZ);
    eval 'sub MSR_IA32_P5_MC_ADDR () {0x;}' unless defined(&MSR_IA32_P5_MC_ADDR);
    eval 'sub MSR_IA32_P5_MC_TYPE () {0x1;}' unless defined(&MSR_IA32_P5_MC_TYPE);
    eval 'sub MSR_IA32_TSC () {0x10;}' unless defined(&MSR_IA32_TSC);
    eval 'sub MSR_IA32_PLATFORM_ID () {0x17;}' unless defined(&MSR_IA32_PLATFORM_ID);
    eval 'sub MSR_IA32_EBL_CR_POWERON () {0x2a;}' unless defined(&MSR_IA32_EBL_CR_POWERON);
    eval 'sub MSR_EBC_FREQUENCY_ID () {0x2c;}' unless defined(&MSR_EBC_FREQUENCY_ID);
    eval 'sub MSR_IA32_FEATURE_CONTROL () {0x3a;}' unless defined(&MSR_IA32_FEATURE_CONTROL);
    eval 'sub FEATURE_CONTROL_LOCKED () {(1<<0);}' unless defined(&FEATURE_CONTROL_LOCKED);
    eval 'sub FEATURE_CONTROL_VMXON_ENABLED_INSIDE_SMX () {(1<<1);}' unless defined(&FEATURE_CONTROL_VMXON_ENABLED_INSIDE_SMX);
    eval 'sub FEATURE_CONTROL_VMXON_ENABLED_OUTSIDE_SMX () {(1<<2);}' unless defined(&FEATURE_CONTROL_VMXON_ENABLED_OUTSIDE_SMX);
    eval 'sub MSR_IA32_APICBASE () {0x1b;}' unless defined(&MSR_IA32_APICBASE);
    eval 'sub MSR_IA32_APICBASE_BSP () {(1<<8);}' unless defined(&MSR_IA32_APICBASE_BSP);
    eval 'sub MSR_IA32_APICBASE_ENABLE () {(1<<11);}' unless defined(&MSR_IA32_APICBASE_ENABLE);
    eval 'sub MSR_IA32_APICBASE_BASE () {(0xfffff<<12);}' unless defined(&MSR_IA32_APICBASE_BASE);
    eval 'sub MSR_IA32_TSCDEADLINE () {0x6e0;}' unless defined(&MSR_IA32_TSCDEADLINE);
    eval 'sub MSR_IA32_UCODE_WRITE () {0x79;}' unless defined(&MSR_IA32_UCODE_WRITE);
    eval 'sub MSR_IA32_UCODE_REV () {0x8b;}' unless defined(&MSR_IA32_UCODE_REV);
    eval 'sub MSR_IA32_PERF_STATUS () {0x198;}' unless defined(&MSR_IA32_PERF_STATUS);
    eval 'sub MSR_IA32_PERF_CTL () {0x199;}' unless defined(&MSR_IA32_PERF_CTL);
    eval 'sub MSR_IA32_MPERF () {0xe7;}' unless defined(&MSR_IA32_MPERF);
    eval 'sub MSR_IA32_APERF () {0xe8;}' unless defined(&MSR_IA32_APERF);
    eval 'sub MSR_IA32_THERM_CONTROL () {0x19a;}' unless defined(&MSR_IA32_THERM_CONTROL);
    eval 'sub MSR_IA32_THERM_INTERRUPT () {0x19b;}' unless defined(&MSR_IA32_THERM_INTERRUPT);
    eval 'sub THERM_INT_HIGH_ENABLE () {(1<< 0);}' unless defined(&THERM_INT_HIGH_ENABLE);
    eval 'sub THERM_INT_LOW_ENABLE () {(1<< 1);}' unless defined(&THERM_INT_LOW_ENABLE);
    eval 'sub THERM_INT_PLN_ENABLE () {(1<< 24);}' unless defined(&THERM_INT_PLN_ENABLE);
    eval 'sub MSR_IA32_THERM_STATUS () {0x19c;}' unless defined(&MSR_IA32_THERM_STATUS);
    eval 'sub THERM_STATUS_PROCHOT () {(1<< 0);}' unless defined(&THERM_STATUS_PROCHOT);
    eval 'sub THERM_STATUS_POWER_LIMIT () {(1<< 10);}' unless defined(&THERM_STATUS_POWER_LIMIT);
    eval 'sub MSR_THERM2_CTL () {0x19d;}' unless defined(&MSR_THERM2_CTL);
    eval 'sub MSR_THERM2_CTL_TM_SELECT () {(1 << 16);}' unless defined(&MSR_THERM2_CTL_TM_SELECT);
    eval 'sub MSR_IA32_MISC_ENABLE () {0x1a0;}' unless defined(&MSR_IA32_MISC_ENABLE);
    eval 'sub MSR_IA32_TEMPERATURE_TARGET () {0x1a2;}' unless defined(&MSR_IA32_TEMPERATURE_TARGET);
    eval 'sub MSR_IA32_ENERGY_PERF_BIAS () {0x1b0;}' unless defined(&MSR_IA32_ENERGY_PERF_BIAS);
    eval 'sub ENERGY_PERF_BIAS_PERFORMANCE () {0;}' unless defined(&ENERGY_PERF_BIAS_PERFORMANCE);
    eval 'sub ENERGY_PERF_BIAS_NORMAL () {6;}' unless defined(&ENERGY_PERF_BIAS_NORMAL);
    eval 'sub ENERGY_PERF_BIAS_POWERSAVE () {15;}' unless defined(&ENERGY_PERF_BIAS_POWERSAVE);
    eval 'sub MSR_IA32_PACKAGE_THERM_STATUS () {0x1b1;}' unless defined(&MSR_IA32_PACKAGE_THERM_STATUS);
    eval 'sub PACKAGE_THERM_STATUS_PROCHOT () {(1<< 0);}' unless defined(&PACKAGE_THERM_STATUS_PROCHOT);
    eval 'sub PACKAGE_THERM_STATUS_POWER_LIMIT () {(1<< 10);}' unless defined(&PACKAGE_THERM_STATUS_POWER_LIMIT);
    eval 'sub MSR_IA32_PACKAGE_THERM_INTERRUPT () {0x1b2;}' unless defined(&MSR_IA32_PACKAGE_THERM_INTERRUPT);
    eval 'sub PACKAGE_THERM_INT_HIGH_ENABLE () {(1<< 0);}' unless defined(&PACKAGE_THERM_INT_HIGH_ENABLE);
    eval 'sub PACKAGE_THERM_INT_LOW_ENABLE () {(1<< 1);}' unless defined(&PACKAGE_THERM_INT_LOW_ENABLE);
    eval 'sub PACKAGE_THERM_INT_PLN_ENABLE () {(1<< 24);}' unless defined(&PACKAGE_THERM_INT_PLN_ENABLE);
    eval 'sub THERM_INT_THRESHOLD0_ENABLE () {(1<< 15);}' unless defined(&THERM_INT_THRESHOLD0_ENABLE);
    eval 'sub THERM_SHIFT_THRESHOLD0 () {8;}' unless defined(&THERM_SHIFT_THRESHOLD0);
    eval 'sub THERM_MASK_THRESHOLD0 () {(0x7f <<  &THERM_SHIFT_THRESHOLD0);}' unless defined(&THERM_MASK_THRESHOLD0);
    eval 'sub THERM_INT_THRESHOLD1_ENABLE () {(1<< 23);}' unless defined(&THERM_INT_THRESHOLD1_ENABLE);
    eval 'sub THERM_SHIFT_THRESHOLD1 () {16;}' unless defined(&THERM_SHIFT_THRESHOLD1);
    eval 'sub THERM_MASK_THRESHOLD1 () {(0x7f <<  &THERM_SHIFT_THRESHOLD1);}' unless defined(&THERM_MASK_THRESHOLD1);
    eval 'sub THERM_STATUS_THRESHOLD0 () {(1<< 6);}' unless defined(&THERM_STATUS_THRESHOLD0);
    eval 'sub THERM_LOG_THRESHOLD0 () {(1<< 7);}' unless defined(&THERM_LOG_THRESHOLD0);
    eval 'sub THERM_STATUS_THRESHOLD1 () {(1<< 8);}' unless defined(&THERM_STATUS_THRESHOLD1);
    eval 'sub THERM_LOG_THRESHOLD1 () {(1<< 9);}' unless defined(&THERM_LOG_THRESHOLD1);
    eval 'sub MSR_IA32_MISC_ENABLE_FAST_STRING () {(1 << 0);}' unless defined(&MSR_IA32_MISC_ENABLE_FAST_STRING);
    eval 'sub MSR_IA32_MISC_ENABLE_TCC () {(1 << 1);}' unless defined(&MSR_IA32_MISC_ENABLE_TCC);
    eval 'sub MSR_IA32_MISC_ENABLE_EMON () {(1 << 7);}' unless defined(&MSR_IA32_MISC_ENABLE_EMON);
    eval 'sub MSR_IA32_MISC_ENABLE_BTS_UNAVAIL () {(1 << 11);}' unless defined(&MSR_IA32_MISC_ENABLE_BTS_UNAVAIL);
    eval 'sub MSR_IA32_MISC_ENABLE_PEBS_UNAVAIL () {(1 << 12);}' unless defined(&MSR_IA32_MISC_ENABLE_PEBS_UNAVAIL);
    eval 'sub MSR_IA32_MISC_ENABLE_ENHANCED_SPEEDSTEP () {(1 << 16);}' unless defined(&MSR_IA32_MISC_ENABLE_ENHANCED_SPEEDSTEP);
    eval 'sub MSR_IA32_MISC_ENABLE_MWAIT () {(1 << 18);}' unless defined(&MSR_IA32_MISC_ENABLE_MWAIT);
    eval 'sub MSR_IA32_MISC_ENABLE_LIMIT_CPUID () {(1 << 22);}' unless defined(&MSR_IA32_MISC_ENABLE_LIMIT_CPUID);
    eval 'sub MSR_IA32_MISC_ENABLE_XTPR_DISABLE () {(1 << 23);}' unless defined(&MSR_IA32_MISC_ENABLE_XTPR_DISABLE);
    eval 'sub MSR_IA32_MISC_ENABLE_XD_DISABLE () {(1 << 34);}' unless defined(&MSR_IA32_MISC_ENABLE_XD_DISABLE);
    eval 'sub MSR_IA32_MISC_ENABLE_X87_COMPAT () {(1 << 2);}' unless defined(&MSR_IA32_MISC_ENABLE_X87_COMPAT);
    eval 'sub MSR_IA32_MISC_ENABLE_TM1 () {(1 << 3);}' unless defined(&MSR_IA32_MISC_ENABLE_TM1);
    eval 'sub MSR_IA32_MISC_ENABLE_SPLIT_LOCK_DISABLE () {(1 << 4);}' unless defined(&MSR_IA32_MISC_ENABLE_SPLIT_LOCK_DISABLE);
    eval 'sub MSR_IA32_MISC_ENABLE_L3CACHE_DISABLE () {(1 << 6);}' unless defined(&MSR_IA32_MISC_ENABLE_L3CACHE_DISABLE);
    eval 'sub MSR_IA32_MISC_ENABLE_SUPPRESS_LOCK () {(1 << 8);}' unless defined(&MSR_IA32_MISC_ENABLE_SUPPRESS_LOCK);
    eval 'sub MSR_IA32_MISC_ENABLE_PREFETCH_DISABLE () {(1 << 9);}' unless defined(&MSR_IA32_MISC_ENABLE_PREFETCH_DISABLE);
    eval 'sub MSR_IA32_MISC_ENABLE_FERR () {(1 << 10);}' unless defined(&MSR_IA32_MISC_ENABLE_FERR);
    eval 'sub MSR_IA32_MISC_ENABLE_FERR_MULTIPLEX () {(1 << 10);}' unless defined(&MSR_IA32_MISC_ENABLE_FERR_MULTIPLEX);
    eval 'sub MSR_IA32_MISC_ENABLE_TM2 () {(1 << 13);}' unless defined(&MSR_IA32_MISC_ENABLE_TM2);
    eval 'sub MSR_IA32_MISC_ENABLE_ADJ_PREF_DISABLE () {(1 << 19);}' unless defined(&MSR_IA32_MISC_ENABLE_ADJ_PREF_DISABLE);
    eval 'sub MSR_IA32_MISC_ENABLE_SPEEDSTEP_LOCK () {(1 << 20);}' unless defined(&MSR_IA32_MISC_ENABLE_SPEEDSTEP_LOCK);
    eval 'sub MSR_IA32_MISC_ENABLE_L1D_CONTEXT () {(1 << 24);}' unless defined(&MSR_IA32_MISC_ENABLE_L1D_CONTEXT);
    eval 'sub MSR_IA32_MISC_ENABLE_DCU_PREF_DISABLE () {(1 << 37);}' unless defined(&MSR_IA32_MISC_ENABLE_DCU_PREF_DISABLE);
    eval 'sub MSR_IA32_MISC_ENABLE_TURBO_DISABLE () {(1 << 38);}' unless defined(&MSR_IA32_MISC_ENABLE_TURBO_DISABLE);
    eval 'sub MSR_IA32_MISC_ENABLE_IP_PREF_DISABLE () {(1 << 39);}' unless defined(&MSR_IA32_MISC_ENABLE_IP_PREF_DISABLE);
    eval 'sub MSR_IA32_MCG_EAX () {0x180;}' unless defined(&MSR_IA32_MCG_EAX);
    eval 'sub MSR_IA32_MCG_EBX () {0x181;}' unless defined(&MSR_IA32_MCG_EBX);
    eval 'sub MSR_IA32_MCG_ECX () {0x182;}' unless defined(&MSR_IA32_MCG_ECX);
    eval 'sub MSR_IA32_MCG_EDX () {0x183;}' unless defined(&MSR_IA32_MCG_EDX);
    eval 'sub MSR_IA32_MCG_ESI () {0x184;}' unless defined(&MSR_IA32_MCG_ESI);
    eval 'sub MSR_IA32_MCG_EDI () {0x185;}' unless defined(&MSR_IA32_MCG_EDI);
    eval 'sub MSR_IA32_MCG_EBP () {0x186;}' unless defined(&MSR_IA32_MCG_EBP);
    eval 'sub MSR_IA32_MCG_ESP () {0x187;}' unless defined(&MSR_IA32_MCG_ESP);
    eval 'sub MSR_IA32_MCG_EFLAGS () {0x188;}' unless defined(&MSR_IA32_MCG_EFLAGS);
    eval 'sub MSR_IA32_MCG_EIP () {0x189;}' unless defined(&MSR_IA32_MCG_EIP);
    eval 'sub MSR_IA32_MCG_RESERVED () {0x18a;}' unless defined(&MSR_IA32_MCG_RESERVED);
    eval 'sub MSR_P4_BPU_PERFCTR0 () {0x300;}' unless defined(&MSR_P4_BPU_PERFCTR0);
    eval 'sub MSR_P4_BPU_PERFCTR1 () {0x301;}' unless defined(&MSR_P4_BPU_PERFCTR1);
    eval 'sub MSR_P4_BPU_PERFCTR2 () {0x302;}' unless defined(&MSR_P4_BPU_PERFCTR2);
    eval 'sub MSR_P4_BPU_PERFCTR3 () {0x303;}' unless defined(&MSR_P4_BPU_PERFCTR3);
    eval 'sub MSR_P4_MS_PERFCTR0 () {0x304;}' unless defined(&MSR_P4_MS_PERFCTR0);
    eval 'sub MSR_P4_MS_PERFCTR1 () {0x305;}' unless defined(&MSR_P4_MS_PERFCTR1);
    eval 'sub MSR_P4_MS_PERFCTR2 () {0x306;}' unless defined(&MSR_P4_MS_PERFCTR2);
    eval 'sub MSR_P4_MS_PERFCTR3 () {0x307;}' unless defined(&MSR_P4_MS_PERFCTR3);
    eval 'sub MSR_P4_FLAME_PERFCTR0 () {0x308;}' unless defined(&MSR_P4_FLAME_PERFCTR0);
    eval 'sub MSR_P4_FLAME_PERFCTR1 () {0x309;}' unless defined(&MSR_P4_FLAME_PERFCTR1);
    eval 'sub MSR_P4_FLAME_PERFCTR2 () {0x30a;}' unless defined(&MSR_P4_FLAME_PERFCTR2);
    eval 'sub MSR_P4_FLAME_PERFCTR3 () {0x30b;}' unless defined(&MSR_P4_FLAME_PERFCTR3);
    eval 'sub MSR_P4_IQ_PERFCTR0 () {0x30c;}' unless defined(&MSR_P4_IQ_PERFCTR0);
    eval 'sub MSR_P4_IQ_PERFCTR1 () {0x30d;}' unless defined(&MSR_P4_IQ_PERFCTR1);
    eval 'sub MSR_P4_IQ_PERFCTR2 () {0x30e;}' unless defined(&MSR_P4_IQ_PERFCTR2);
    eval 'sub MSR_P4_IQ_PERFCTR3 () {0x30f;}' unless defined(&MSR_P4_IQ_PERFCTR3);
    eval 'sub MSR_P4_IQ_PERFCTR4 () {0x310;}' unless defined(&MSR_P4_IQ_PERFCTR4);
    eval 'sub MSR_P4_IQ_PERFCTR5 () {0x311;}' unless defined(&MSR_P4_IQ_PERFCTR5);
    eval 'sub MSR_P4_BPU_CCCR0 () {0x360;}' unless defined(&MSR_P4_BPU_CCCR0);
    eval 'sub MSR_P4_BPU_CCCR1 () {0x361;}' unless defined(&MSR_P4_BPU_CCCR1);
    eval 'sub MSR_P4_BPU_CCCR2 () {0x362;}' unless defined(&MSR_P4_BPU_CCCR2);
    eval 'sub MSR_P4_BPU_CCCR3 () {0x363;}' unless defined(&MSR_P4_BPU_CCCR3);
    eval 'sub MSR_P4_MS_CCCR0 () {0x364;}' unless defined(&MSR_P4_MS_CCCR0);
    eval 'sub MSR_P4_MS_CCCR1 () {0x365;}' unless defined(&MSR_P4_MS_CCCR1);
    eval 'sub MSR_P4_MS_CCCR2 () {0x366;}' unless defined(&MSR_P4_MS_CCCR2);
    eval 'sub MSR_P4_MS_CCCR3 () {0x367;}' unless defined(&MSR_P4_MS_CCCR3);
    eval 'sub MSR_P4_FLAME_CCCR0 () {0x368;}' unless defined(&MSR_P4_FLAME_CCCR0);
    eval 'sub MSR_P4_FLAME_CCCR1 () {0x369;}' unless defined(&MSR_P4_FLAME_CCCR1);
    eval 'sub MSR_P4_FLAME_CCCR2 () {0x36a;}' unless defined(&MSR_P4_FLAME_CCCR2);
    eval 'sub MSR_P4_FLAME_CCCR3 () {0x36b;}' unless defined(&MSR_P4_FLAME_CCCR3);
    eval 'sub MSR_P4_IQ_CCCR0 () {0x36c;}' unless defined(&MSR_P4_IQ_CCCR0);
    eval 'sub MSR_P4_IQ_CCCR1 () {0x36d;}' unless defined(&MSR_P4_IQ_CCCR1);
    eval 'sub MSR_P4_IQ_CCCR2 () {0x36e;}' unless defined(&MSR_P4_IQ_CCCR2);
    eval 'sub MSR_P4_IQ_CCCR3 () {0x36f;}' unless defined(&MSR_P4_IQ_CCCR3);
    eval 'sub MSR_P4_IQ_CCCR4 () {0x370;}' unless defined(&MSR_P4_IQ_CCCR4);
    eval 'sub MSR_P4_IQ_CCCR5 () {0x371;}' unless defined(&MSR_P4_IQ_CCCR5);
    eval 'sub MSR_P4_ALF_ESCR0 () {0x3ca;}' unless defined(&MSR_P4_ALF_ESCR0);
    eval 'sub MSR_P4_ALF_ESCR1 () {0x3cb;}' unless defined(&MSR_P4_ALF_ESCR1);
    eval 'sub MSR_P4_BPU_ESCR0 () {0x3b2;}' unless defined(&MSR_P4_BPU_ESCR0);
    eval 'sub MSR_P4_BPU_ESCR1 () {0x3b3;}' unless defined(&MSR_P4_BPU_ESCR1);
    eval 'sub MSR_P4_BSU_ESCR0 () {0x3a0;}' unless defined(&MSR_P4_BSU_ESCR0);
    eval 'sub MSR_P4_BSU_ESCR1 () {0x3a1;}' unless defined(&MSR_P4_BSU_ESCR1);
    eval 'sub MSR_P4_CRU_ESCR0 () {0x3b8;}' unless defined(&MSR_P4_CRU_ESCR0);
    eval 'sub MSR_P4_CRU_ESCR1 () {0x3b9;}' unless defined(&MSR_P4_CRU_ESCR1);
    eval 'sub MSR_P4_CRU_ESCR2 () {0x3cc;}' unless defined(&MSR_P4_CRU_ESCR2);
    eval 'sub MSR_P4_CRU_ESCR3 () {0x3cd;}' unless defined(&MSR_P4_CRU_ESCR3);
    eval 'sub MSR_P4_CRU_ESCR4 () {0x3e0;}' unless defined(&MSR_P4_CRU_ESCR4);
    eval 'sub MSR_P4_CRU_ESCR5 () {0x3e1;}' unless defined(&MSR_P4_CRU_ESCR5);
    eval 'sub MSR_P4_DAC_ESCR0 () {0x3a8;}' unless defined(&MSR_P4_DAC_ESCR0);
    eval 'sub MSR_P4_DAC_ESCR1 () {0x3a9;}' unless defined(&MSR_P4_DAC_ESCR1);
    eval 'sub MSR_P4_FIRM_ESCR0 () {0x3a4;}' unless defined(&MSR_P4_FIRM_ESCR0);
    eval 'sub MSR_P4_FIRM_ESCR1 () {0x3a5;}' unless defined(&MSR_P4_FIRM_ESCR1);
    eval 'sub MSR_P4_FLAME_ESCR0 () {0x3a6;}' unless defined(&MSR_P4_FLAME_ESCR0);
    eval 'sub MSR_P4_FLAME_ESCR1 () {0x3a7;}' unless defined(&MSR_P4_FLAME_ESCR1);
    eval 'sub MSR_P4_FSB_ESCR0 () {0x3a2;}' unless defined(&MSR_P4_FSB_ESCR0);
    eval 'sub MSR_P4_FSB_ESCR1 () {0x3a3;}' unless defined(&MSR_P4_FSB_ESCR1);
    eval 'sub MSR_P4_IQ_ESCR0 () {0x3ba;}' unless defined(&MSR_P4_IQ_ESCR0);
    eval 'sub MSR_P4_IQ_ESCR1 () {0x3bb;}' unless defined(&MSR_P4_IQ_ESCR1);
    eval 'sub MSR_P4_IS_ESCR0 () {0x3b4;}' unless defined(&MSR_P4_IS_ESCR0);
    eval 'sub MSR_P4_IS_ESCR1 () {0x3b5;}' unless defined(&MSR_P4_IS_ESCR1);
    eval 'sub MSR_P4_ITLB_ESCR0 () {0x3b6;}' unless defined(&MSR_P4_ITLB_ESCR0);
    eval 'sub MSR_P4_ITLB_ESCR1 () {0x3b7;}' unless defined(&MSR_P4_ITLB_ESCR1);
    eval 'sub MSR_P4_IX_ESCR0 () {0x3c8;}' unless defined(&MSR_P4_IX_ESCR0);
    eval 'sub MSR_P4_IX_ESCR1 () {0x3c9;}' unless defined(&MSR_P4_IX_ESCR1);
    eval 'sub MSR_P4_MOB_ESCR0 () {0x3aa;}' unless defined(&MSR_P4_MOB_ESCR0);
    eval 'sub MSR_P4_MOB_ESCR1 () {0x3ab;}' unless defined(&MSR_P4_MOB_ESCR1);
    eval 'sub MSR_P4_MS_ESCR0 () {0x3c0;}' unless defined(&MSR_P4_MS_ESCR0);
    eval 'sub MSR_P4_MS_ESCR1 () {0x3c1;}' unless defined(&MSR_P4_MS_ESCR1);
    eval 'sub MSR_P4_PMH_ESCR0 () {0x3ac;}' unless defined(&MSR_P4_PMH_ESCR0);
    eval 'sub MSR_P4_PMH_ESCR1 () {0x3ad;}' unless defined(&MSR_P4_PMH_ESCR1);
    eval 'sub MSR_P4_RAT_ESCR0 () {0x3bc;}' unless defined(&MSR_P4_RAT_ESCR0);
    eval 'sub MSR_P4_RAT_ESCR1 () {0x3bd;}' unless defined(&MSR_P4_RAT_ESCR1);
    eval 'sub MSR_P4_SAAT_ESCR0 () {0x3ae;}' unless defined(&MSR_P4_SAAT_ESCR0);
    eval 'sub MSR_P4_SAAT_ESCR1 () {0x3af;}' unless defined(&MSR_P4_SAAT_ESCR1);
    eval 'sub MSR_P4_SSU_ESCR0 () {0x3be;}' unless defined(&MSR_P4_SSU_ESCR0);
    eval 'sub MSR_P4_SSU_ESCR1 () {0x3bf;}' unless defined(&MSR_P4_SSU_ESCR1);
    eval 'sub MSR_P4_TBPU_ESCR0 () {0x3c2;}' unless defined(&MSR_P4_TBPU_ESCR0);
    eval 'sub MSR_P4_TBPU_ESCR1 () {0x3c3;}' unless defined(&MSR_P4_TBPU_ESCR1);
    eval 'sub MSR_P4_TC_ESCR0 () {0x3c4;}' unless defined(&MSR_P4_TC_ESCR0);
    eval 'sub MSR_P4_TC_ESCR1 () {0x3c5;}' unless defined(&MSR_P4_TC_ESCR1);
    eval 'sub MSR_P4_U2L_ESCR0 () {0x3b0;}' unless defined(&MSR_P4_U2L_ESCR0);
    eval 'sub MSR_P4_U2L_ESCR1 () {0x3b1;}' unless defined(&MSR_P4_U2L_ESCR1);
    eval 'sub MSR_P4_PEBS_MATRIX_VERT () {0x3f2;}' unless defined(&MSR_P4_PEBS_MATRIX_VERT);
    eval 'sub MSR_CORE_PERF_FIXED_CTR0 () {0x309;}' unless defined(&MSR_CORE_PERF_FIXED_CTR0);
    eval 'sub MSR_CORE_PERF_FIXED_CTR1 () {0x30a;}' unless defined(&MSR_CORE_PERF_FIXED_CTR1);
    eval 'sub MSR_CORE_PERF_FIXED_CTR2 () {0x30b;}' unless defined(&MSR_CORE_PERF_FIXED_CTR2);
    eval 'sub MSR_CORE_PERF_FIXED_CTR_CTRL () {0x38d;}' unless defined(&MSR_CORE_PERF_FIXED_CTR_CTRL);
    eval 'sub MSR_CORE_PERF_GLOBAL_STATUS () {0x38e;}' unless defined(&MSR_CORE_PERF_GLOBAL_STATUS);
    eval 'sub MSR_CORE_PERF_GLOBAL_CTRL () {0x38f;}' unless defined(&MSR_CORE_PERF_GLOBAL_CTRL);
    eval 'sub MSR_CORE_PERF_GLOBAL_OVF_CTRL () {0x390;}' unless defined(&MSR_CORE_PERF_GLOBAL_OVF_CTRL);
    eval 'sub MSR_GEODE_BUSCONT_CONF0 () {0x1900;}' unless defined(&MSR_GEODE_BUSCONT_CONF0);
    eval 'sub MSR_IA32_VMX_BASIC () {0x480;}' unless defined(&MSR_IA32_VMX_BASIC);
    eval 'sub MSR_IA32_VMX_PINBASED_CTLS () {0x481;}' unless defined(&MSR_IA32_VMX_PINBASED_CTLS);
    eval 'sub MSR_IA32_VMX_PROCBASED_CTLS () {0x482;}' unless defined(&MSR_IA32_VMX_PROCBASED_CTLS);
    eval 'sub MSR_IA32_VMX_EXIT_CTLS () {0x483;}' unless defined(&MSR_IA32_VMX_EXIT_CTLS);
    eval 'sub MSR_IA32_VMX_ENTRY_CTLS () {0x484;}' unless defined(&MSR_IA32_VMX_ENTRY_CTLS);
    eval 'sub MSR_IA32_VMX_MISC () {0x485;}' unless defined(&MSR_IA32_VMX_MISC);
    eval 'sub MSR_IA32_VMX_CR0_FIXED0 () {0x486;}' unless defined(&MSR_IA32_VMX_CR0_FIXED0);
    eval 'sub MSR_IA32_VMX_CR0_FIXED1 () {0x487;}' unless defined(&MSR_IA32_VMX_CR0_FIXED1);
    eval 'sub MSR_IA32_VMX_CR4_FIXED0 () {0x488;}' unless defined(&MSR_IA32_VMX_CR4_FIXED0);
    eval 'sub MSR_IA32_VMX_CR4_FIXED1 () {0x489;}' unless defined(&MSR_IA32_VMX_CR4_FIXED1);
    eval 'sub MSR_IA32_VMX_VMCS_ENUM () {0x48a;}' unless defined(&MSR_IA32_VMX_VMCS_ENUM);
    eval 'sub MSR_IA32_VMX_PROCBASED_CTLS2 () {0x48b;}' unless defined(&MSR_IA32_VMX_PROCBASED_CTLS2);
    eval 'sub MSR_IA32_VMX_EPT_VPID_CAP () {0x48c;}' unless defined(&MSR_IA32_VMX_EPT_VPID_CAP);
    eval 'sub MSR_IA32_VMX_TRUE_PINBASED_CTLS () {0x48d;}' unless defined(&MSR_IA32_VMX_TRUE_PINBASED_CTLS);
    eval 'sub MSR_IA32_VMX_TRUE_PROCBASED_CTLS () {0x48e;}' unless defined(&MSR_IA32_VMX_TRUE_PROCBASED_CTLS);
    eval 'sub MSR_IA32_VMX_TRUE_EXIT_CTLS () {0x48f;}' unless defined(&MSR_IA32_VMX_TRUE_EXIT_CTLS);
    eval 'sub MSR_IA32_VMX_TRUE_ENTRY_CTLS () {0x490;}' unless defined(&MSR_IA32_VMX_TRUE_ENTRY_CTLS);
    eval 'sub VMX_BASIC_VMCS_SIZE_SHIFT () {32;}' unless defined(&VMX_BASIC_VMCS_SIZE_SHIFT);
    eval 'sub VMX_BASIC_64 () {0x1000000000000;}' unless defined(&VMX_BASIC_64);
    eval 'sub VMX_BASIC_MEM_TYPE_SHIFT () {50;}' unless defined(&VMX_BASIC_MEM_TYPE_SHIFT);
    eval 'sub VMX_BASIC_MEM_TYPE_MASK () {0x3c000000000000;}' unless defined(&VMX_BASIC_MEM_TYPE_MASK);
    eval 'sub VMX_BASIC_MEM_TYPE_WB () {6;}' unless defined(&VMX_BASIC_MEM_TYPE_WB);
    eval 'sub VMX_BASIC_INOUT () {0x40000000000000;}' unless defined(&VMX_BASIC_INOUT);
    eval 'sub MSR_VM_CR () {0xc0010114;}' unless defined(&MSR_VM_CR);
    eval 'sub MSR_VM_IGNNE () {0xc0010115;}' unless defined(&MSR_VM_IGNNE);
    eval 'sub MSR_VM_HSAVE_PA () {0xc0010117;}' unless defined(&MSR_VM_HSAVE_PA);
}
1;
