#!/bin/bash
#
#%stage: softraid
#
mdblockdev=

# Full mdadm.conf generated by mdadm.
# Contains all created MD RAIDs
mdadm_conf=

cont_list=
md_devs=

declare -A md_conf
# blockdev contains real devices (/dev/X) for root, resume, journal, dumb
for bd in $blockdev ; do
    is_part_dev=false
    case $bd in
	/dev/md[0-9]*p[0-9]*)
	    # Partitionable MD RAID. This is partition on RAID. Get the RAID
	    bd=${bd%%p[0-9]*}
	    is_part_dev=true
	    ;;
	/dev/md[0-9]*)
	    ;;
	*)
	    mdblockdev="$mdblockdev $bd"
	    continue
	    ;;
    esac
    # Check if this device is already added (possible for partitionable).
    md_dev=`mdadm -D --export $bd | sed -n -e 's/^MD_DEVNAME=//p'`
    if [ -z "$md_dev" ]; then
        md_dev=${bd##/dev/}
    else
	bd="/dev/md/$md_dev"
    fi
    dup_found=false
    for dup in $md_devs; do
	if [ x"$dup" = x"$md_dev" ]; then
	    dup_found=true
	    break
	fi
    done
    if $dup_found; then
	if ! $is_part_dev; then
	    echo "setup-md.sh: $md_dev found multiple times" >&2
	fi
        continue
    fi
    mdconf=$(mdadm -Db "$bd")
    if test -z "$mdconf"; then
        mdblockdev="$mdblockdev $bd"
        continue
    fi
    md_tmpblockdev=$(mdadm -Dbv $bd | sed -n "1D;s/,/ /g;s/^ *devices=//p")
    mdblockdev="$mdblockdev $md_tmpblockdev"
    md_devs="$md_devs $md_dev"
    container=$(echo "$mdconf" | sed -rn 's/.* container=([^ ]*) .*/\1/p')
    for cnt in $cont_list; do
        if [ x"$container" = x"$cnt" ]; then
            container=
            break
        fi
    done
    case "$container" in
    "")
        ;;
    /dev/*)
        mdconf="$(mdadm -Db "$container")\\n$mdconf"
	cont_list="$cont_list $container"
        ;;
    [0-9a-f]*[0-9a-f])
        if test -z "$mdadm_conf"; then
            mdadm_conf=$(mdadm --examine --brief --scan)
        fi
        mdconf="$(echo "$mdadm_conf" | grep "UUID=$container")\\n$mdconf"
	cont_list="$cont_list $container"
        ;;
    *)
        echo "unrecognized container for $md_dev: $container"
        ;;
    esac
    md_conf["$md_dev"]="$mdconf"
    root_md=1
done

# Any 'md' device is replaced by it's component disks.
blockdev="$mdblockdev"

if [ -n "$root_md" ] ; then
    need_mdadm=1
    echo "AUTO -all" > $tmp_mnt/etc/mdadm.conf
    for md in $md_devs; do
        echo -e "${md_conf["$md"]}" >> $tmp_mnt/etc/mdadm.conf
    done
fi
# Remember which arrays are needed for the root or swap device and assemble
# them all during boot. The root= or resume= option might not directly refer to
# the array.
if test -n "$md_devs"; then
    md_devs=$(printf '/dev/%s ' $md_devs)
fi

save_var need_mdadm
save_var md_devs
