require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__need_schedparam)) {
    unless(defined(&_SCHED_H)) {
	die("Never include <bits/sched.h> directly; use <sched.h> instead.");
    }
    eval 'sub SCHED_OTHER () {0;}' unless defined(&SCHED_OTHER);
    eval 'sub SCHED_FIFO () {1;}' unless defined(&SCHED_FIFO);
    eval 'sub SCHED_RR () {2;}' unless defined(&SCHED_RR);
    if(defined(&__USE_GNU)) {
	eval 'sub SCHED_BATCH () {3;}' unless defined(&SCHED_BATCH);
	eval 'sub SCHED_IDLE () {5;}' unless defined(&SCHED_IDLE);
	eval 'sub SCHED_RESET_ON_FORK () {0x40000000;}' unless defined(&SCHED_RESET_ON_FORK);
    }
    if(defined(&__USE_GNU)) {
	eval 'sub CSIGNAL () {0xff;}' unless defined(&CSIGNAL);
	eval 'sub CLONE_VM () {0x100;}' unless defined(&CLONE_VM);
	eval 'sub CLONE_FS () {0x200;}' unless defined(&CLONE_FS);
	eval 'sub CLONE_FILES () {0x400;}' unless defined(&CLONE_FILES);
	eval 'sub CLONE_SIGHAND () {0x800;}' unless defined(&CLONE_SIGHAND);
	eval 'sub CLONE_PTRACE () {0x2000;}' unless defined(&CLONE_PTRACE);
	eval 'sub CLONE_VFORK () {0x4000;}' unless defined(&CLONE_VFORK);
	eval 'sub CLONE_PARENT () {0x8000;}' unless defined(&CLONE_PARENT);
	eval 'sub CLONE_THREAD () {0x10000;}' unless defined(&CLONE_THREAD);
	eval 'sub CLONE_NEWNS () {0x20000;}' unless defined(&CLONE_NEWNS);
	eval 'sub CLONE_SYSVSEM () {0x40000;}' unless defined(&CLONE_SYSVSEM);
	eval 'sub CLONE_SETTLS () {0x80000;}' unless defined(&CLONE_SETTLS);
	eval 'sub CLONE_PARENT_SETTID () {0x100000;}' unless defined(&CLONE_PARENT_SETTID);
	eval 'sub CLONE_CHILD_CLEARTID () {0x200000;}' unless defined(&CLONE_CHILD_CLEARTID);
	eval 'sub CLONE_DETACHED () {0x400000;}' unless defined(&CLONE_DETACHED);
	eval 'sub CLONE_UNTRACED () {0x800000;}' unless defined(&CLONE_UNTRACED);
	eval 'sub CLONE_CHILD_SETTID () {0x1000000;}' unless defined(&CLONE_CHILD_SETTID);
	eval 'sub CLONE_NEWUTS () {0x4000000;}' unless defined(&CLONE_NEWUTS);
	eval 'sub CLONE_NEWIPC () {0x8000000;}' unless defined(&CLONE_NEWIPC);
	eval 'sub CLONE_NEWUSER () {0x10000000;}' unless defined(&CLONE_NEWUSER);
	eval 'sub CLONE_NEWPID () {0x20000000;}' unless defined(&CLONE_NEWPID);
	eval 'sub CLONE_NEWNET () {0x40000000;}' unless defined(&CLONE_NEWNET);
	eval 'sub CLONE_IO () {0x80000000;}' unless defined(&CLONE_IO);
    }
    if(defined(&__USE_GNU)) {
    }
}
if(!defined (&__defined_schedparam)  && (defined (&__need_schedparam) || defined (&_SCHED_H))) {
    eval 'sub __defined_schedparam () {1;}' unless defined(&__defined_schedparam);
    undef(&__need_schedparam) if defined(&__need_schedparam);
}
if(defined (&_SCHED_H)  && !defined (&__cpu_set_t_defined)) {
    eval 'sub __cpu_set_t_defined () {1;}' unless defined(&__cpu_set_t_defined);
    eval 'sub __CPU_SETSIZE () {4096;}' unless defined(&__CPU_SETSIZE);
    eval 'sub __NCPUBITS () {(8* $sizeof{ &__cpu_mask});}' unless defined(&__NCPUBITS);
    eval 'sub __CPUELT {
        my($cpu) = @_;
	    eval q((($cpu) /  &__NCPUBITS));
    }' unless defined(&__CPUELT);
    eval 'sub __CPUMASK {
        my($cpu) = @_;
	    eval q((( &__cpu_mask) 1<< (($cpu) %  &__NCPUBITS)));
    }' unless defined(&__CPUMASK);
    if( &__GNUC_PREREQ (2, 91)) {
	eval 'sub __CPU_ZERO_S {
	    my($setsize, $cpusetp) = @_;
    	    eval q( &do  &__builtin_memset ($cpusetp, ord(\'\\\\0\'), $setsize);  &while (0));
	}' unless defined(&__CPU_ZERO_S);
    } else {
	eval 'sub __CPU_ZERO_S {
	    my($setsize, $cpusetp) = @_;
    	    eval q( &do { \'size_t\'  &__i; \'size_t\'  &__imax = ($setsize) / $sizeof{ &__cpu_mask};  &__cpu_mask * &__bits = ($cpusetp)-> &__bits;  &for ( &__i = 0;  &__i <  &__imax; ++ &__i)  $__bits[ &__i] = 0; }  &while (0));
	}' unless defined(&__CPU_ZERO_S);
    }
    eval 'sub __CPU_SET_S {
        my($cpu, $setsize, $cpusetp) = @_;
	    eval q(( &__extension__ ({ \'size_t\'  &__cpu = ($cpu);  &__cpu < 8* ($setsize) ? ((( &__cpu_mask *) (($cpusetp)-> &__bits))[ &__CPUELT ( &__cpu)] |=  &__CPUMASK ( &__cpu)) : 0; })));
    }' unless defined(&__CPU_SET_S);
    eval 'sub __CPU_CLR_S {
        my($cpu, $setsize, $cpusetp) = @_;
	    eval q(( &__extension__ ({ \'size_t\'  &__cpu = ($cpu);  &__cpu < 8* ($setsize) ? ((( &__cpu_mask *) (($cpusetp)-> &__bits))[ &__CPUELT ( &__cpu)] &= ~ &__CPUMASK ( &__cpu)) : 0; })));
    }' unless defined(&__CPU_CLR_S);
    eval 'sub __CPU_ISSET_S {
        my($cpu, $setsize, $cpusetp) = @_;
	    eval q(( &__extension__ ({ \'size_t\'  &__cpu = ($cpu);  &__cpu < 8* ($setsize) ? (((( &__const  &__cpu_mask *) (($cpusetp)-> &__bits))[ &__CPUELT ( &__cpu)] &  &__CPUMASK ( &__cpu))) != 0: 0; })));
    }' unless defined(&__CPU_ISSET_S);
    eval 'sub __CPU_COUNT_S {
        my($setsize, $cpusetp) = @_;
	    eval q( &__sched_cpucount ($setsize, $cpusetp));
    }' unless defined(&__CPU_COUNT_S);
    if( &__GNUC_PREREQ (2, 91)) {
	eval 'sub __CPU_EQUAL_S {
	    my($setsize, $cpusetp1, $cpusetp2) = @_;
    	    eval q(( &__builtin_memcmp ($cpusetp1, $cpusetp2, $setsize) == 0));
	}' unless defined(&__CPU_EQUAL_S);
    } else {
	eval 'sub __CPU_EQUAL_S {
	    my($setsize, $cpusetp1, $cpusetp2) = @_;
    	    eval q(( &__extension__ ({  &__const  &__cpu_mask * &__arr1 = ($cpusetp1)-> &__bits;  &__const  &__cpu_mask * &__arr2 = ($cpusetp2)-> &__bits; \'size_t\'  &__imax = ($setsize) / $sizeof{ &__cpu_mask}; \'size_t\'  &__i;  &for ( &__i = 0;  &__i <  &__imax; ++ &__i)  &if ( $__bits[ &__i] !=  $__bits[ &__i])  &break;  &__i ==  &__imax; })));
	}' unless defined(&__CPU_EQUAL_S);
    }
    eval 'sub __CPU_OP_S {
        my($setsize, $destset, $srcset1, $srcset2, $op) = @_;
	    eval q(( &__extension__ ({  &cpu_set_t * &__dest = ($destset);  &__const  &__cpu_mask * &__arr1 = ($srcset1)-> &__bits;  &__const  &__cpu_mask * &__arr2 = ($srcset2)-> &__bits; \'size_t\'  &__imax = ($setsize) / $sizeof{ &__cpu_mask}; \'size_t\'  &__i;  &for ( &__i = 0;  &__i <  &__imax; ++ &__i) (( &__cpu_mask *)  ($__dest->{__bits}))[ &__i] =  $__arr1[ &__i] $op  $__arr2[ &__i];  &__dest; })));
    }' unless defined(&__CPU_OP_S);
    eval 'sub __CPU_ALLOC_SIZE {
        my($count) = @_;
	    eval q((((($count) +  &__NCPUBITS - 1) /  &__NCPUBITS) * $sizeof{ &__cpu_mask}));
    }' unless defined(&__CPU_ALLOC_SIZE);
    eval 'sub __CPU_ALLOC {
        my($count) = @_;
	    eval q( &__sched_cpualloc ($count));
    }' unless defined(&__CPU_ALLOC);
    eval 'sub __CPU_FREE {
        my($cpuset) = @_;
	    eval q( &__sched_cpufree ($cpuset));
    }' unless defined(&__CPU_FREE);
}
1;
