require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&LINUX_PCI_REGS_H)) {
    eval 'sub LINUX_PCI_REGS_H () {1;}' unless defined(&LINUX_PCI_REGS_H);
    eval 'sub PCI_VENDOR_ID () {0x;}' unless defined(&PCI_VENDOR_ID);
    eval 'sub PCI_DEVICE_ID () {0x2;}' unless defined(&PCI_DEVICE_ID);
    eval 'sub PCI_COMMAND () {0x4;}' unless defined(&PCI_COMMAND);
    eval 'sub PCI_COMMAND_IO () {0x1;}' unless defined(&PCI_COMMAND_IO);
    eval 'sub PCI_COMMAND_MEMORY () {0x2;}' unless defined(&PCI_COMMAND_MEMORY);
    eval 'sub PCI_COMMAND_MASTER () {0x4;}' unless defined(&PCI_COMMAND_MASTER);
    eval 'sub PCI_COMMAND_SPECIAL () {0x8;}' unless defined(&PCI_COMMAND_SPECIAL);
    eval 'sub PCI_COMMAND_INVALIDATE () {0x10;}' unless defined(&PCI_COMMAND_INVALIDATE);
    eval 'sub PCI_COMMAND_VGA_PALETTE () {0x20;}' unless defined(&PCI_COMMAND_VGA_PALETTE);
    eval 'sub PCI_COMMAND_PARITY () {0x40;}' unless defined(&PCI_COMMAND_PARITY);
    eval 'sub PCI_COMMAND_WAIT () {0x80;}' unless defined(&PCI_COMMAND_WAIT);
    eval 'sub PCI_COMMAND_SERR () {0x100;}' unless defined(&PCI_COMMAND_SERR);
    eval 'sub PCI_COMMAND_FAST_BACK () {0x200;}' unless defined(&PCI_COMMAND_FAST_BACK);
    eval 'sub PCI_COMMAND_INTX_DISABLE () {0x400;}' unless defined(&PCI_COMMAND_INTX_DISABLE);
    eval 'sub PCI_STATUS () {0x6;}' unless defined(&PCI_STATUS);
    eval 'sub PCI_STATUS_INTERRUPT () {0x8;}' unless defined(&PCI_STATUS_INTERRUPT);
    eval 'sub PCI_STATUS_CAP_LIST () {0x10;}' unless defined(&PCI_STATUS_CAP_LIST);
    eval 'sub PCI_STATUS_66MHZ () {0x20;}' unless defined(&PCI_STATUS_66MHZ);
    eval 'sub PCI_STATUS_UDF () {0x40;}' unless defined(&PCI_STATUS_UDF);
    eval 'sub PCI_STATUS_FAST_BACK () {0x80;}' unless defined(&PCI_STATUS_FAST_BACK);
    eval 'sub PCI_STATUS_PARITY () {0x100;}' unless defined(&PCI_STATUS_PARITY);
    eval 'sub PCI_STATUS_DEVSEL_MASK () {0x600;}' unless defined(&PCI_STATUS_DEVSEL_MASK);
    eval 'sub PCI_STATUS_DEVSEL_FAST () {0x;}' unless defined(&PCI_STATUS_DEVSEL_FAST);
    eval 'sub PCI_STATUS_DEVSEL_MEDIUM () {0x200;}' unless defined(&PCI_STATUS_DEVSEL_MEDIUM);
    eval 'sub PCI_STATUS_DEVSEL_SLOW () {0x400;}' unless defined(&PCI_STATUS_DEVSEL_SLOW);
    eval 'sub PCI_STATUS_SIG_TARGET_ABORT () {0x800;}' unless defined(&PCI_STATUS_SIG_TARGET_ABORT);
    eval 'sub PCI_STATUS_REC_TARGET_ABORT () {0x1000;}' unless defined(&PCI_STATUS_REC_TARGET_ABORT);
    eval 'sub PCI_STATUS_REC_MASTER_ABORT () {0x2000;}' unless defined(&PCI_STATUS_REC_MASTER_ABORT);
    eval 'sub PCI_STATUS_SIG_SYSTEM_ERROR () {0x4000;}' unless defined(&PCI_STATUS_SIG_SYSTEM_ERROR);
    eval 'sub PCI_STATUS_DETECTED_PARITY () {0x8000;}' unless defined(&PCI_STATUS_DETECTED_PARITY);
    eval 'sub PCI_CLASS_REVISION () {0x8;}' unless defined(&PCI_CLASS_REVISION);
    eval 'sub PCI_REVISION_ID () {0x8;}' unless defined(&PCI_REVISION_ID);
    eval 'sub PCI_CLASS_PROG () {0x9;}' unless defined(&PCI_CLASS_PROG);
    eval 'sub PCI_CLASS_DEVICE () {0xa;}' unless defined(&PCI_CLASS_DEVICE);
    eval 'sub PCI_CACHE_LINE_SIZE () {0xc;}' unless defined(&PCI_CACHE_LINE_SIZE);
    eval 'sub PCI_LATENCY_TIMER () {0xd;}' unless defined(&PCI_LATENCY_TIMER);
    eval 'sub PCI_HEADER_TYPE () {0xe;}' unless defined(&PCI_HEADER_TYPE);
    eval 'sub PCI_HEADER_TYPE_NORMAL () {0;}' unless defined(&PCI_HEADER_TYPE_NORMAL);
    eval 'sub PCI_HEADER_TYPE_BRIDGE () {1;}' unless defined(&PCI_HEADER_TYPE_BRIDGE);
    eval 'sub PCI_HEADER_TYPE_CARDBUS () {2;}' unless defined(&PCI_HEADER_TYPE_CARDBUS);
    eval 'sub PCI_BIST () {0xf;}' unless defined(&PCI_BIST);
    eval 'sub PCI_BIST_CODE_MASK () {0xf;}' unless defined(&PCI_BIST_CODE_MASK);
    eval 'sub PCI_BIST_START () {0x40;}' unless defined(&PCI_BIST_START);
    eval 'sub PCI_BIST_CAPABLE () {0x80;}' unless defined(&PCI_BIST_CAPABLE);
    eval 'sub PCI_BASE_ADDRESS_0 () {0x10;}' unless defined(&PCI_BASE_ADDRESS_0);
    eval 'sub PCI_BASE_ADDRESS_1 () {0x14;}' unless defined(&PCI_BASE_ADDRESS_1);
    eval 'sub PCI_BASE_ADDRESS_2 () {0x18;}' unless defined(&PCI_BASE_ADDRESS_2);
    eval 'sub PCI_BASE_ADDRESS_3 () {0x1c;}' unless defined(&PCI_BASE_ADDRESS_3);
    eval 'sub PCI_BASE_ADDRESS_4 () {0x20;}' unless defined(&PCI_BASE_ADDRESS_4);
    eval 'sub PCI_BASE_ADDRESS_5 () {0x24;}' unless defined(&PCI_BASE_ADDRESS_5);
    eval 'sub PCI_BASE_ADDRESS_SPACE () {0x1;}' unless defined(&PCI_BASE_ADDRESS_SPACE);
    eval 'sub PCI_BASE_ADDRESS_SPACE_IO () {0x1;}' unless defined(&PCI_BASE_ADDRESS_SPACE_IO);
    eval 'sub PCI_BASE_ADDRESS_SPACE_MEMORY () {0x;}' unless defined(&PCI_BASE_ADDRESS_SPACE_MEMORY);
    eval 'sub PCI_BASE_ADDRESS_MEM_TYPE_MASK () {0x6;}' unless defined(&PCI_BASE_ADDRESS_MEM_TYPE_MASK);
    eval 'sub PCI_BASE_ADDRESS_MEM_TYPE_32 () {0x;}' unless defined(&PCI_BASE_ADDRESS_MEM_TYPE_32);
    eval 'sub PCI_BASE_ADDRESS_MEM_TYPE_1M () {0x2;}' unless defined(&PCI_BASE_ADDRESS_MEM_TYPE_1M);
    eval 'sub PCI_BASE_ADDRESS_MEM_TYPE_64 () {0x4;}' unless defined(&PCI_BASE_ADDRESS_MEM_TYPE_64);
    eval 'sub PCI_BASE_ADDRESS_MEM_PREFETCH () {0x8;}' unless defined(&PCI_BASE_ADDRESS_MEM_PREFETCH);
    eval 'sub PCI_BASE_ADDRESS_MEM_MASK () {(~0xf);}' unless defined(&PCI_BASE_ADDRESS_MEM_MASK);
    eval 'sub PCI_BASE_ADDRESS_IO_MASK () {(~0x3);}' unless defined(&PCI_BASE_ADDRESS_IO_MASK);
    eval 'sub PCI_CARDBUS_CIS () {0x28;}' unless defined(&PCI_CARDBUS_CIS);
    eval 'sub PCI_SUBSYSTEM_VENDOR_ID () {0x2c;}' unless defined(&PCI_SUBSYSTEM_VENDOR_ID);
    eval 'sub PCI_SUBSYSTEM_ID () {0x2e;}' unless defined(&PCI_SUBSYSTEM_ID);
    eval 'sub PCI_ROM_ADDRESS () {0x30;}' unless defined(&PCI_ROM_ADDRESS);
    eval 'sub PCI_ROM_ADDRESS_ENABLE () {0x1;}' unless defined(&PCI_ROM_ADDRESS_ENABLE);
    eval 'sub PCI_ROM_ADDRESS_MASK () {(~0x7ff);}' unless defined(&PCI_ROM_ADDRESS_MASK);
    eval 'sub PCI_CAPABILITY_LIST () {0x34;}' unless defined(&PCI_CAPABILITY_LIST);
    eval 'sub PCI_INTERRUPT_LINE () {0x3c;}' unless defined(&PCI_INTERRUPT_LINE);
    eval 'sub PCI_INTERRUPT_PIN () {0x3d;}' unless defined(&PCI_INTERRUPT_PIN);
    eval 'sub PCI_MIN_GNT () {0x3e;}' unless defined(&PCI_MIN_GNT);
    eval 'sub PCI_MAX_LAT () {0x3f;}' unless defined(&PCI_MAX_LAT);
    eval 'sub PCI_PRIMARY_BUS () {0x18;}' unless defined(&PCI_PRIMARY_BUS);
    eval 'sub PCI_SECONDARY_BUS () {0x19;}' unless defined(&PCI_SECONDARY_BUS);
    eval 'sub PCI_SUBORDINATE_BUS () {0x1a;}' unless defined(&PCI_SUBORDINATE_BUS);
    eval 'sub PCI_SEC_LATENCY_TIMER () {0x1b;}' unless defined(&PCI_SEC_LATENCY_TIMER);
    eval 'sub PCI_IO_BASE () {0x1c;}' unless defined(&PCI_IO_BASE);
    eval 'sub PCI_IO_LIMIT () {0x1d;}' unless defined(&PCI_IO_LIMIT);
    eval 'sub PCI_IO_RANGE_TYPE_MASK () {0xf;}' unless defined(&PCI_IO_RANGE_TYPE_MASK);
    eval 'sub PCI_IO_RANGE_TYPE_16 () {0x;}' unless defined(&PCI_IO_RANGE_TYPE_16);
    eval 'sub PCI_IO_RANGE_TYPE_32 () {0x1;}' unless defined(&PCI_IO_RANGE_TYPE_32);
    eval 'sub PCI_IO_RANGE_MASK () {(~0xf);}' unless defined(&PCI_IO_RANGE_MASK);
    eval 'sub PCI_SEC_STATUS () {0x1e;}' unless defined(&PCI_SEC_STATUS);
    eval 'sub PCI_MEMORY_BASE () {0x20;}' unless defined(&PCI_MEMORY_BASE);
    eval 'sub PCI_MEMORY_LIMIT () {0x22;}' unless defined(&PCI_MEMORY_LIMIT);
    eval 'sub PCI_MEMORY_RANGE_TYPE_MASK () {0xf;}' unless defined(&PCI_MEMORY_RANGE_TYPE_MASK);
    eval 'sub PCI_MEMORY_RANGE_MASK () {(~0xf);}' unless defined(&PCI_MEMORY_RANGE_MASK);
    eval 'sub PCI_PREF_MEMORY_BASE () {0x24;}' unless defined(&PCI_PREF_MEMORY_BASE);
    eval 'sub PCI_PREF_MEMORY_LIMIT () {0x26;}' unless defined(&PCI_PREF_MEMORY_LIMIT);
    eval 'sub PCI_PREF_RANGE_TYPE_MASK () {0xf;}' unless defined(&PCI_PREF_RANGE_TYPE_MASK);
    eval 'sub PCI_PREF_RANGE_TYPE_32 () {0x;}' unless defined(&PCI_PREF_RANGE_TYPE_32);
    eval 'sub PCI_PREF_RANGE_TYPE_64 () {0x1;}' unless defined(&PCI_PREF_RANGE_TYPE_64);
    eval 'sub PCI_PREF_RANGE_MASK () {(~0xf);}' unless defined(&PCI_PREF_RANGE_MASK);
    eval 'sub PCI_PREF_BASE_UPPER32 () {0x28;}' unless defined(&PCI_PREF_BASE_UPPER32);
    eval 'sub PCI_PREF_LIMIT_UPPER32 () {0x2c;}' unless defined(&PCI_PREF_LIMIT_UPPER32);
    eval 'sub PCI_IO_BASE_UPPER16 () {0x30;}' unless defined(&PCI_IO_BASE_UPPER16);
    eval 'sub PCI_IO_LIMIT_UPPER16 () {0x32;}' unless defined(&PCI_IO_LIMIT_UPPER16);
    eval 'sub PCI_ROM_ADDRESS1 () {0x38;}' unless defined(&PCI_ROM_ADDRESS1);
    eval 'sub PCI_BRIDGE_CONTROL () {0x3e;}' unless defined(&PCI_BRIDGE_CONTROL);
    eval 'sub PCI_BRIDGE_CTL_PARITY () {0x1;}' unless defined(&PCI_BRIDGE_CTL_PARITY);
    eval 'sub PCI_BRIDGE_CTL_SERR () {0x2;}' unless defined(&PCI_BRIDGE_CTL_SERR);
    eval 'sub PCI_BRIDGE_CTL_ISA () {0x4;}' unless defined(&PCI_BRIDGE_CTL_ISA);
    eval 'sub PCI_BRIDGE_CTL_VGA () {0x8;}' unless defined(&PCI_BRIDGE_CTL_VGA);
    eval 'sub PCI_BRIDGE_CTL_MASTER_ABORT () {0x20;}' unless defined(&PCI_BRIDGE_CTL_MASTER_ABORT);
    eval 'sub PCI_BRIDGE_CTL_BUS_RESET () {0x40;}' unless defined(&PCI_BRIDGE_CTL_BUS_RESET);
    eval 'sub PCI_BRIDGE_CTL_FAST_BACK () {0x80;}' unless defined(&PCI_BRIDGE_CTL_FAST_BACK);
    eval 'sub PCI_CB_CAPABILITY_LIST () {0x14;}' unless defined(&PCI_CB_CAPABILITY_LIST);
    eval 'sub PCI_CB_SEC_STATUS () {0x16;}' unless defined(&PCI_CB_SEC_STATUS);
    eval 'sub PCI_CB_PRIMARY_BUS () {0x18;}' unless defined(&PCI_CB_PRIMARY_BUS);
    eval 'sub PCI_CB_CARD_BUS () {0x19;}' unless defined(&PCI_CB_CARD_BUS);
    eval 'sub PCI_CB_SUBORDINATE_BUS () {0x1a;}' unless defined(&PCI_CB_SUBORDINATE_BUS);
    eval 'sub PCI_CB_LATENCY_TIMER () {0x1b;}' unless defined(&PCI_CB_LATENCY_TIMER);
    eval 'sub PCI_CB_MEMORY_BASE_0 () {0x1c;}' unless defined(&PCI_CB_MEMORY_BASE_0);
    eval 'sub PCI_CB_MEMORY_LIMIT_0 () {0x20;}' unless defined(&PCI_CB_MEMORY_LIMIT_0);
    eval 'sub PCI_CB_MEMORY_BASE_1 () {0x24;}' unless defined(&PCI_CB_MEMORY_BASE_1);
    eval 'sub PCI_CB_MEMORY_LIMIT_1 () {0x28;}' unless defined(&PCI_CB_MEMORY_LIMIT_1);
    eval 'sub PCI_CB_IO_BASE_0 () {0x2c;}' unless defined(&PCI_CB_IO_BASE_0);
    eval 'sub PCI_CB_IO_BASE_0_HI () {0x2e;}' unless defined(&PCI_CB_IO_BASE_0_HI);
    eval 'sub PCI_CB_IO_LIMIT_0 () {0x30;}' unless defined(&PCI_CB_IO_LIMIT_0);
    eval 'sub PCI_CB_IO_LIMIT_0_HI () {0x32;}' unless defined(&PCI_CB_IO_LIMIT_0_HI);
    eval 'sub PCI_CB_IO_BASE_1 () {0x34;}' unless defined(&PCI_CB_IO_BASE_1);
    eval 'sub PCI_CB_IO_BASE_1_HI () {0x36;}' unless defined(&PCI_CB_IO_BASE_1_HI);
    eval 'sub PCI_CB_IO_LIMIT_1 () {0x38;}' unless defined(&PCI_CB_IO_LIMIT_1);
    eval 'sub PCI_CB_IO_LIMIT_1_HI () {0x3a;}' unless defined(&PCI_CB_IO_LIMIT_1_HI);
    eval 'sub PCI_CB_IO_RANGE_MASK () {(~0x3);}' unless defined(&PCI_CB_IO_RANGE_MASK);
    eval 'sub PCI_CB_BRIDGE_CONTROL () {0x3e;}' unless defined(&PCI_CB_BRIDGE_CONTROL);
    eval 'sub PCI_CB_BRIDGE_CTL_PARITY () {0x1;}' unless defined(&PCI_CB_BRIDGE_CTL_PARITY);
    eval 'sub PCI_CB_BRIDGE_CTL_SERR () {0x2;}' unless defined(&PCI_CB_BRIDGE_CTL_SERR);
    eval 'sub PCI_CB_BRIDGE_CTL_ISA () {0x4;}' unless defined(&PCI_CB_BRIDGE_CTL_ISA);
    eval 'sub PCI_CB_BRIDGE_CTL_VGA () {0x8;}' unless defined(&PCI_CB_BRIDGE_CTL_VGA);
    eval 'sub PCI_CB_BRIDGE_CTL_MASTER_ABORT () {0x20;}' unless defined(&PCI_CB_BRIDGE_CTL_MASTER_ABORT);
    eval 'sub PCI_CB_BRIDGE_CTL_CB_RESET () {0x40;}' unless defined(&PCI_CB_BRIDGE_CTL_CB_RESET);
    eval 'sub PCI_CB_BRIDGE_CTL_16BIT_INT () {0x80;}' unless defined(&PCI_CB_BRIDGE_CTL_16BIT_INT);
    eval 'sub PCI_CB_BRIDGE_CTL_PREFETCH_MEM0 () {0x100;}' unless defined(&PCI_CB_BRIDGE_CTL_PREFETCH_MEM0);
    eval 'sub PCI_CB_BRIDGE_CTL_PREFETCH_MEM1 () {0x200;}' unless defined(&PCI_CB_BRIDGE_CTL_PREFETCH_MEM1);
    eval 'sub PCI_CB_BRIDGE_CTL_POST_WRITES () {0x400;}' unless defined(&PCI_CB_BRIDGE_CTL_POST_WRITES);
    eval 'sub PCI_CB_SUBSYSTEM_VENDOR_ID () {0x40;}' unless defined(&PCI_CB_SUBSYSTEM_VENDOR_ID);
    eval 'sub PCI_CB_SUBSYSTEM_ID () {0x42;}' unless defined(&PCI_CB_SUBSYSTEM_ID);
    eval 'sub PCI_CB_LEGACY_MODE_BASE () {0x44;}' unless defined(&PCI_CB_LEGACY_MODE_BASE);
    eval 'sub PCI_CAP_LIST_ID () {0;}' unless defined(&PCI_CAP_LIST_ID);
    eval 'sub PCI_CAP_ID_PM () {0x1;}' unless defined(&PCI_CAP_ID_PM);
    eval 'sub PCI_CAP_ID_AGP () {0x2;}' unless defined(&PCI_CAP_ID_AGP);
    eval 'sub PCI_CAP_ID_VPD () {0x3;}' unless defined(&PCI_CAP_ID_VPD);
    eval 'sub PCI_CAP_ID_SLOTID () {0x4;}' unless defined(&PCI_CAP_ID_SLOTID);
    eval 'sub PCI_CAP_ID_MSI () {0x5;}' unless defined(&PCI_CAP_ID_MSI);
    eval 'sub PCI_CAP_ID_CHSWP () {0x6;}' unless defined(&PCI_CAP_ID_CHSWP);
    eval 'sub PCI_CAP_ID_PCIX () {0x7;}' unless defined(&PCI_CAP_ID_PCIX);
    eval 'sub PCI_CAP_ID_HT () {0x8;}' unless defined(&PCI_CAP_ID_HT);
    eval 'sub PCI_CAP_ID_VNDR () {0x9;}' unless defined(&PCI_CAP_ID_VNDR);
    eval 'sub PCI_CAP_ID_DBG () {0xa;}' unless defined(&PCI_CAP_ID_DBG);
    eval 'sub PCI_CAP_ID_CCRC () {0xb;}' unless defined(&PCI_CAP_ID_CCRC);
    eval 'sub PCI_CAP_ID_SHPC () {0xc;}' unless defined(&PCI_CAP_ID_SHPC);
    eval 'sub PCI_CAP_ID_SSVID () {0xd;}' unless defined(&PCI_CAP_ID_SSVID);
    eval 'sub PCI_CAP_ID_AGP3 () {0xe;}' unless defined(&PCI_CAP_ID_AGP3);
    eval 'sub PCI_CAP_ID_EXP () {0x10;}' unless defined(&PCI_CAP_ID_EXP);
    eval 'sub PCI_CAP_ID_MSIX () {0x11;}' unless defined(&PCI_CAP_ID_MSIX);
    eval 'sub PCI_CAP_ID_AF () {0x13;}' unless defined(&PCI_CAP_ID_AF);
    eval 'sub PCI_CAP_LIST_NEXT () {1;}' unless defined(&PCI_CAP_LIST_NEXT);
    eval 'sub PCI_CAP_FLAGS () {2;}' unless defined(&PCI_CAP_FLAGS);
    eval 'sub PCI_CAP_SIZEOF () {4;}' unless defined(&PCI_CAP_SIZEOF);
    eval 'sub PCI_PM_PMC () {2;}' unless defined(&PCI_PM_PMC);
    eval 'sub PCI_PM_CAP_VER_MASK () {0x7;}' unless defined(&PCI_PM_CAP_VER_MASK);
    eval 'sub PCI_PM_CAP_PME_CLOCK () {0x8;}' unless defined(&PCI_PM_CAP_PME_CLOCK);
    eval 'sub PCI_PM_CAP_RESERVED () {0x10;}' unless defined(&PCI_PM_CAP_RESERVED);
    eval 'sub PCI_PM_CAP_DSI () {0x20;}' unless defined(&PCI_PM_CAP_DSI);
    eval 'sub PCI_PM_CAP_AUX_POWER () {0x1c0;}' unless defined(&PCI_PM_CAP_AUX_POWER);
    eval 'sub PCI_PM_CAP_D1 () {0x200;}' unless defined(&PCI_PM_CAP_D1);
    eval 'sub PCI_PM_CAP_D2 () {0x400;}' unless defined(&PCI_PM_CAP_D2);
    eval 'sub PCI_PM_CAP_PME () {0x800;}' unless defined(&PCI_PM_CAP_PME);
    eval 'sub PCI_PM_CAP_PME_MASK () {0xf800;}' unless defined(&PCI_PM_CAP_PME_MASK);
    eval 'sub PCI_PM_CAP_PME_D0 () {0x800;}' unless defined(&PCI_PM_CAP_PME_D0);
    eval 'sub PCI_PM_CAP_PME_D1 () {0x1000;}' unless defined(&PCI_PM_CAP_PME_D1);
    eval 'sub PCI_PM_CAP_PME_D2 () {0x2000;}' unless defined(&PCI_PM_CAP_PME_D2);
    eval 'sub PCI_PM_CAP_PME_D3 () {0x4000;}' unless defined(&PCI_PM_CAP_PME_D3);
    eval 'sub PCI_PM_CAP_PME_D3cold () {0x8000;}' unless defined(&PCI_PM_CAP_PME_D3cold);
    eval 'sub PCI_PM_CAP_PME_SHIFT () {11;}' unless defined(&PCI_PM_CAP_PME_SHIFT);
    eval 'sub PCI_PM_CTRL () {4;}' unless defined(&PCI_PM_CTRL);
    eval 'sub PCI_PM_CTRL_STATE_MASK () {0x3;}' unless defined(&PCI_PM_CTRL_STATE_MASK);
    eval 'sub PCI_PM_CTRL_NO_SOFT_RESET () {0x8;}' unless defined(&PCI_PM_CTRL_NO_SOFT_RESET);
    eval 'sub PCI_PM_CTRL_PME_ENABLE () {0x100;}' unless defined(&PCI_PM_CTRL_PME_ENABLE);
    eval 'sub PCI_PM_CTRL_DATA_SEL_MASK () {0x1e00;}' unless defined(&PCI_PM_CTRL_DATA_SEL_MASK);
    eval 'sub PCI_PM_CTRL_DATA_SCALE_MASK () {0x6000;}' unless defined(&PCI_PM_CTRL_DATA_SCALE_MASK);
    eval 'sub PCI_PM_CTRL_PME_STATUS () {0x8000;}' unless defined(&PCI_PM_CTRL_PME_STATUS);
    eval 'sub PCI_PM_PPB_EXTENSIONS () {6;}' unless defined(&PCI_PM_PPB_EXTENSIONS);
    eval 'sub PCI_PM_PPB_B2_B3 () {0x40;}' unless defined(&PCI_PM_PPB_B2_B3);
    eval 'sub PCI_PM_BPCC_ENABLE () {0x80;}' unless defined(&PCI_PM_BPCC_ENABLE);
    eval 'sub PCI_PM_DATA_REGISTER () {7;}' unless defined(&PCI_PM_DATA_REGISTER);
    eval 'sub PCI_PM_SIZEOF () {8;}' unless defined(&PCI_PM_SIZEOF);
    eval 'sub PCI_AGP_VERSION () {2;}' unless defined(&PCI_AGP_VERSION);
    eval 'sub PCI_AGP_RFU () {3;}' unless defined(&PCI_AGP_RFU);
    eval 'sub PCI_AGP_STATUS () {4;}' unless defined(&PCI_AGP_STATUS);
    eval 'sub PCI_AGP_STATUS_RQ_MASK () {0xff000000;}' unless defined(&PCI_AGP_STATUS_RQ_MASK);
    eval 'sub PCI_AGP_STATUS_SBA () {0x200;}' unless defined(&PCI_AGP_STATUS_SBA);
    eval 'sub PCI_AGP_STATUS_64BIT () {0x20;}' unless defined(&PCI_AGP_STATUS_64BIT);
    eval 'sub PCI_AGP_STATUS_FW () {0x10;}' unless defined(&PCI_AGP_STATUS_FW);
    eval 'sub PCI_AGP_STATUS_RATE4 () {0x4;}' unless defined(&PCI_AGP_STATUS_RATE4);
    eval 'sub PCI_AGP_STATUS_RATE2 () {0x2;}' unless defined(&PCI_AGP_STATUS_RATE2);
    eval 'sub PCI_AGP_STATUS_RATE1 () {0x1;}' unless defined(&PCI_AGP_STATUS_RATE1);
    eval 'sub PCI_AGP_COMMAND () {8;}' unless defined(&PCI_AGP_COMMAND);
    eval 'sub PCI_AGP_COMMAND_RQ_MASK () {0xff000000;}' unless defined(&PCI_AGP_COMMAND_RQ_MASK);
    eval 'sub PCI_AGP_COMMAND_SBA () {0x200;}' unless defined(&PCI_AGP_COMMAND_SBA);
    eval 'sub PCI_AGP_COMMAND_AGP () {0x100;}' unless defined(&PCI_AGP_COMMAND_AGP);
    eval 'sub PCI_AGP_COMMAND_64BIT () {0x20;}' unless defined(&PCI_AGP_COMMAND_64BIT);
    eval 'sub PCI_AGP_COMMAND_FW () {0x10;}' unless defined(&PCI_AGP_COMMAND_FW);
    eval 'sub PCI_AGP_COMMAND_RATE4 () {0x4;}' unless defined(&PCI_AGP_COMMAND_RATE4);
    eval 'sub PCI_AGP_COMMAND_RATE2 () {0x2;}' unless defined(&PCI_AGP_COMMAND_RATE2);
    eval 'sub PCI_AGP_COMMAND_RATE1 () {0x1;}' unless defined(&PCI_AGP_COMMAND_RATE1);
    eval 'sub PCI_AGP_SIZEOF () {12;}' unless defined(&PCI_AGP_SIZEOF);
    eval 'sub PCI_VPD_ADDR () {2;}' unless defined(&PCI_VPD_ADDR);
    eval 'sub PCI_VPD_ADDR_MASK () {0x7fff;}' unless defined(&PCI_VPD_ADDR_MASK);
    eval 'sub PCI_VPD_ADDR_F () {0x8000;}' unless defined(&PCI_VPD_ADDR_F);
    eval 'sub PCI_VPD_DATA () {4;}' unless defined(&PCI_VPD_DATA);
    eval 'sub PCI_SID_ESR () {2;}' unless defined(&PCI_SID_ESR);
    eval 'sub PCI_SID_ESR_NSLOTS () {0x1f;}' unless defined(&PCI_SID_ESR_NSLOTS);
    eval 'sub PCI_SID_ESR_FIC () {0x20;}' unless defined(&PCI_SID_ESR_FIC);
    eval 'sub PCI_SID_CHASSIS_NR () {3;}' unless defined(&PCI_SID_CHASSIS_NR);
    eval 'sub PCI_MSI_FLAGS () {2;}' unless defined(&PCI_MSI_FLAGS);
    eval 'sub PCI_MSI_FLAGS_64BIT () {0x80;}' unless defined(&PCI_MSI_FLAGS_64BIT);
    eval 'sub PCI_MSI_FLAGS_QSIZE () {0x70;}' unless defined(&PCI_MSI_FLAGS_QSIZE);
    eval 'sub PCI_MSI_FLAGS_QMASK () {0xe;}' unless defined(&PCI_MSI_FLAGS_QMASK);
    eval 'sub PCI_MSI_FLAGS_ENABLE () {0x1;}' unless defined(&PCI_MSI_FLAGS_ENABLE);
    eval 'sub PCI_MSI_FLAGS_MASKBIT () {0x100;}' unless defined(&PCI_MSI_FLAGS_MASKBIT);
    eval 'sub PCI_MSI_RFU () {3;}' unless defined(&PCI_MSI_RFU);
    eval 'sub PCI_MSI_ADDRESS_LO () {4;}' unless defined(&PCI_MSI_ADDRESS_LO);
    eval 'sub PCI_MSI_ADDRESS_HI () {8;}' unless defined(&PCI_MSI_ADDRESS_HI);
    eval 'sub PCI_MSI_DATA_32 () {8;}' unless defined(&PCI_MSI_DATA_32);
    eval 'sub PCI_MSI_MASK_32 () {12;}' unless defined(&PCI_MSI_MASK_32);
    eval 'sub PCI_MSI_DATA_64 () {12;}' unless defined(&PCI_MSI_DATA_64);
    eval 'sub PCI_MSI_MASK_64 () {16;}' unless defined(&PCI_MSI_MASK_64);
    eval 'sub PCI_MSIX_FLAGS () {2;}' unless defined(&PCI_MSIX_FLAGS);
    eval 'sub PCI_MSIX_FLAGS_QSIZE () {0x7ff;}' unless defined(&PCI_MSIX_FLAGS_QSIZE);
    eval 'sub PCI_MSIX_FLAGS_ENABLE () {(1<< 15);}' unless defined(&PCI_MSIX_FLAGS_ENABLE);
    eval 'sub PCI_MSIX_FLAGS_MASKALL () {(1<< 14);}' unless defined(&PCI_MSIX_FLAGS_MASKALL);
    eval 'sub PCI_MSIX_FLAGS_BIRMASK () {(7<< 0);}' unless defined(&PCI_MSIX_FLAGS_BIRMASK);
    eval 'sub PCI_CHSWP_CSR () {2;}' unless defined(&PCI_CHSWP_CSR);
    eval 'sub PCI_CHSWP_DHA () {0x1;}' unless defined(&PCI_CHSWP_DHA);
    eval 'sub PCI_CHSWP_EIM () {0x2;}' unless defined(&PCI_CHSWP_EIM);
    eval 'sub PCI_CHSWP_PIE () {0x4;}' unless defined(&PCI_CHSWP_PIE);
    eval 'sub PCI_CHSWP_LOO () {0x8;}' unless defined(&PCI_CHSWP_LOO);
    eval 'sub PCI_CHSWP_PI () {0x30;}' unless defined(&PCI_CHSWP_PI);
    eval 'sub PCI_CHSWP_EXT () {0x40;}' unless defined(&PCI_CHSWP_EXT);
    eval 'sub PCI_CHSWP_INS () {0x80;}' unless defined(&PCI_CHSWP_INS);
    eval 'sub PCI_AF_LENGTH () {2;}' unless defined(&PCI_AF_LENGTH);
    eval 'sub PCI_AF_CAP () {3;}' unless defined(&PCI_AF_CAP);
    eval 'sub PCI_AF_CAP_TP () {0x1;}' unless defined(&PCI_AF_CAP_TP);
    eval 'sub PCI_AF_CAP_FLR () {0x2;}' unless defined(&PCI_AF_CAP_FLR);
    eval 'sub PCI_AF_CTRL () {4;}' unless defined(&PCI_AF_CTRL);
    eval 'sub PCI_AF_CTRL_FLR () {0x1;}' unless defined(&PCI_AF_CTRL_FLR);
    eval 'sub PCI_AF_STATUS () {5;}' unless defined(&PCI_AF_STATUS);
    eval 'sub PCI_AF_STATUS_TP () {0x1;}' unless defined(&PCI_AF_STATUS_TP);
    eval 'sub PCI_X_CMD () {2;}' unless defined(&PCI_X_CMD);
    eval 'sub PCI_X_CMD_DPERR_E () {0x1;}' unless defined(&PCI_X_CMD_DPERR_E);
    eval 'sub PCI_X_CMD_ERO () {0x2;}' unless defined(&PCI_X_CMD_ERO);
    eval 'sub PCI_X_CMD_READ_512 () {0x;}' unless defined(&PCI_X_CMD_READ_512);
    eval 'sub PCI_X_CMD_READ_1K () {0x4;}' unless defined(&PCI_X_CMD_READ_1K);
    eval 'sub PCI_X_CMD_READ_2K () {0x8;}' unless defined(&PCI_X_CMD_READ_2K);
    eval 'sub PCI_X_CMD_READ_4K () {0xc;}' unless defined(&PCI_X_CMD_READ_4K);
    eval 'sub PCI_X_CMD_MAX_READ () {0xc;}' unless defined(&PCI_X_CMD_MAX_READ);
    eval 'sub PCI_X_CMD_SPLIT_1 () {0x;}' unless defined(&PCI_X_CMD_SPLIT_1);
    eval 'sub PCI_X_CMD_SPLIT_2 () {0x10;}' unless defined(&PCI_X_CMD_SPLIT_2);
    eval 'sub PCI_X_CMD_SPLIT_3 () {0x20;}' unless defined(&PCI_X_CMD_SPLIT_3);
    eval 'sub PCI_X_CMD_SPLIT_4 () {0x30;}' unless defined(&PCI_X_CMD_SPLIT_4);
    eval 'sub PCI_X_CMD_SPLIT_8 () {0x40;}' unless defined(&PCI_X_CMD_SPLIT_8);
    eval 'sub PCI_X_CMD_SPLIT_12 () {0x50;}' unless defined(&PCI_X_CMD_SPLIT_12);
    eval 'sub PCI_X_CMD_SPLIT_16 () {0x60;}' unless defined(&PCI_X_CMD_SPLIT_16);
    eval 'sub PCI_X_CMD_SPLIT_32 () {0x70;}' unless defined(&PCI_X_CMD_SPLIT_32);
    eval 'sub PCI_X_CMD_MAX_SPLIT () {0x70;}' unless defined(&PCI_X_CMD_MAX_SPLIT);
    eval 'sub PCI_X_CMD_VERSION {
        my($x) = @_;
	    eval q(((($x) >> 12) & 3));
    }' unless defined(&PCI_X_CMD_VERSION);
    eval 'sub PCI_X_STATUS () {4;}' unless defined(&PCI_X_STATUS);
    eval 'sub PCI_X_STATUS_DEVFN () {0xff;}' unless defined(&PCI_X_STATUS_DEVFN);
    eval 'sub PCI_X_STATUS_BUS () {0xff00;}' unless defined(&PCI_X_STATUS_BUS);
    eval 'sub PCI_X_STATUS_64BIT () {0x10000;}' unless defined(&PCI_X_STATUS_64BIT);
    eval 'sub PCI_X_STATUS_133MHZ () {0x20000;}' unless defined(&PCI_X_STATUS_133MHZ);
    eval 'sub PCI_X_STATUS_SPL_DISC () {0x40000;}' unless defined(&PCI_X_STATUS_SPL_DISC);
    eval 'sub PCI_X_STATUS_UNX_SPL () {0x80000;}' unless defined(&PCI_X_STATUS_UNX_SPL);
    eval 'sub PCI_X_STATUS_COMPLEX () {0x100000;}' unless defined(&PCI_X_STATUS_COMPLEX);
    eval 'sub PCI_X_STATUS_MAX_READ () {0x600000;}' unless defined(&PCI_X_STATUS_MAX_READ);
    eval 'sub PCI_X_STATUS_MAX_SPLIT () {0x3800000;}' unless defined(&PCI_X_STATUS_MAX_SPLIT);
    eval 'sub PCI_X_STATUS_MAX_CUM () {0x1c000000;}' unless defined(&PCI_X_STATUS_MAX_CUM);
    eval 'sub PCI_X_STATUS_SPL_ERR () {0x20000000;}' unless defined(&PCI_X_STATUS_SPL_ERR);
    eval 'sub PCI_X_STATUS_266MHZ () {0x40000000;}' unless defined(&PCI_X_STATUS_266MHZ);
    eval 'sub PCI_X_STATUS_533MHZ () {0x80000000;}' unless defined(&PCI_X_STATUS_533MHZ);
    eval 'sub PCI_SSVID_VENDOR_ID () {4;}' unless defined(&PCI_SSVID_VENDOR_ID);
    eval 'sub PCI_SSVID_DEVICE_ID () {6;}' unless defined(&PCI_SSVID_DEVICE_ID);
    eval 'sub PCI_EXP_FLAGS () {2;}' unless defined(&PCI_EXP_FLAGS);
    eval 'sub PCI_EXP_FLAGS_VERS () {0xf;}' unless defined(&PCI_EXP_FLAGS_VERS);
    eval 'sub PCI_EXP_FLAGS_TYPE () {0xf0;}' unless defined(&PCI_EXP_FLAGS_TYPE);
    eval 'sub PCI_EXP_TYPE_ENDPOINT () {0x;}' unless defined(&PCI_EXP_TYPE_ENDPOINT);
    eval 'sub PCI_EXP_TYPE_LEG_END () {0x1;}' unless defined(&PCI_EXP_TYPE_LEG_END);
    eval 'sub PCI_EXP_TYPE_ROOT_PORT () {0x4;}' unless defined(&PCI_EXP_TYPE_ROOT_PORT);
    eval 'sub PCI_EXP_TYPE_UPSTREAM () {0x5;}' unless defined(&PCI_EXP_TYPE_UPSTREAM);
    eval 'sub PCI_EXP_TYPE_DOWNSTREAM () {0x6;}' unless defined(&PCI_EXP_TYPE_DOWNSTREAM);
    eval 'sub PCI_EXP_TYPE_PCI_BRIDGE () {0x7;}' unless defined(&PCI_EXP_TYPE_PCI_BRIDGE);
    eval 'sub PCI_EXP_TYPE_RC_END () {0x9;}' unless defined(&PCI_EXP_TYPE_RC_END);
    eval 'sub PCI_EXP_TYPE_RC_EC () {0x10;}' unless defined(&PCI_EXP_TYPE_RC_EC);
    eval 'sub PCI_EXP_FLAGS_SLOT () {0x100;}' unless defined(&PCI_EXP_FLAGS_SLOT);
    eval 'sub PCI_EXP_FLAGS_IRQ () {0x3e00;}' unless defined(&PCI_EXP_FLAGS_IRQ);
    eval 'sub PCI_EXP_DEVCAP () {4;}' unless defined(&PCI_EXP_DEVCAP);
    eval 'sub PCI_EXP_DEVCAP_PAYLOAD () {0x7;}' unless defined(&PCI_EXP_DEVCAP_PAYLOAD);
    eval 'sub PCI_EXP_DEVCAP_PHANTOM () {0x18;}' unless defined(&PCI_EXP_DEVCAP_PHANTOM);
    eval 'sub PCI_EXP_DEVCAP_EXT_TAG () {0x20;}' unless defined(&PCI_EXP_DEVCAP_EXT_TAG);
    eval 'sub PCI_EXP_DEVCAP_L0S () {0x1c0;}' unless defined(&PCI_EXP_DEVCAP_L0S);
    eval 'sub PCI_EXP_DEVCAP_L1 () {0xe00;}' unless defined(&PCI_EXP_DEVCAP_L1);
    eval 'sub PCI_EXP_DEVCAP_ATN_BUT () {0x1000;}' unless defined(&PCI_EXP_DEVCAP_ATN_BUT);
    eval 'sub PCI_EXP_DEVCAP_ATN_IND () {0x2000;}' unless defined(&PCI_EXP_DEVCAP_ATN_IND);
    eval 'sub PCI_EXP_DEVCAP_PWR_IND () {0x4000;}' unless defined(&PCI_EXP_DEVCAP_PWR_IND);
    eval 'sub PCI_EXP_DEVCAP_RBER () {0x8000;}' unless defined(&PCI_EXP_DEVCAP_RBER);
    eval 'sub PCI_EXP_DEVCAP_PWR_VAL () {0x3fc0000;}' unless defined(&PCI_EXP_DEVCAP_PWR_VAL);
    eval 'sub PCI_EXP_DEVCAP_PWR_SCL () {0xc000000;}' unless defined(&PCI_EXP_DEVCAP_PWR_SCL);
    eval 'sub PCI_EXP_DEVCAP_FLR () {0x10000000;}' unless defined(&PCI_EXP_DEVCAP_FLR);
    eval 'sub PCI_EXP_DEVCTL () {8;}' unless defined(&PCI_EXP_DEVCTL);
    eval 'sub PCI_EXP_DEVCTL_CERE () {0x1;}' unless defined(&PCI_EXP_DEVCTL_CERE);
    eval 'sub PCI_EXP_DEVCTL_NFERE () {0x2;}' unless defined(&PCI_EXP_DEVCTL_NFERE);
    eval 'sub PCI_EXP_DEVCTL_FERE () {0x4;}' unless defined(&PCI_EXP_DEVCTL_FERE);
    eval 'sub PCI_EXP_DEVCTL_URRE () {0x8;}' unless defined(&PCI_EXP_DEVCTL_URRE);
    eval 'sub PCI_EXP_DEVCTL_RELAX_EN () {0x10;}' unless defined(&PCI_EXP_DEVCTL_RELAX_EN);
    eval 'sub PCI_EXP_DEVCTL_PAYLOAD () {0xe0;}' unless defined(&PCI_EXP_DEVCTL_PAYLOAD);
    eval 'sub PCI_EXP_DEVCTL_EXT_TAG () {0x100;}' unless defined(&PCI_EXP_DEVCTL_EXT_TAG);
    eval 'sub PCI_EXP_DEVCTL_PHANTOM () {0x200;}' unless defined(&PCI_EXP_DEVCTL_PHANTOM);
    eval 'sub PCI_EXP_DEVCTL_AUX_PME () {0x400;}' unless defined(&PCI_EXP_DEVCTL_AUX_PME);
    eval 'sub PCI_EXP_DEVCTL_NOSNOOP_EN () {0x800;}' unless defined(&PCI_EXP_DEVCTL_NOSNOOP_EN);
    eval 'sub PCI_EXP_DEVCTL_READRQ () {0x7000;}' unless defined(&PCI_EXP_DEVCTL_READRQ);
    eval 'sub PCI_EXP_DEVCTL_BCR_FLR () {0x8000;}' unless defined(&PCI_EXP_DEVCTL_BCR_FLR);
    eval 'sub PCI_EXP_DEVSTA () {10;}' unless defined(&PCI_EXP_DEVSTA);
    eval 'sub PCI_EXP_DEVSTA_CED () {0x1;}' unless defined(&PCI_EXP_DEVSTA_CED);
    eval 'sub PCI_EXP_DEVSTA_NFED () {0x2;}' unless defined(&PCI_EXP_DEVSTA_NFED);
    eval 'sub PCI_EXP_DEVSTA_FED () {0x4;}' unless defined(&PCI_EXP_DEVSTA_FED);
    eval 'sub PCI_EXP_DEVSTA_URD () {0x8;}' unless defined(&PCI_EXP_DEVSTA_URD);
    eval 'sub PCI_EXP_DEVSTA_AUXPD () {0x10;}' unless defined(&PCI_EXP_DEVSTA_AUXPD);
    eval 'sub PCI_EXP_DEVSTA_TRPND () {0x20;}' unless defined(&PCI_EXP_DEVSTA_TRPND);
    eval 'sub PCI_EXP_LNKCAP () {12;}' unless defined(&PCI_EXP_LNKCAP);
    eval 'sub PCI_EXP_LNKCAP_SLS () {0xf;}' unless defined(&PCI_EXP_LNKCAP_SLS);
    eval 'sub PCI_EXP_LNKCAP_MLW () {0x3f0;}' unless defined(&PCI_EXP_LNKCAP_MLW);
    eval 'sub PCI_EXP_LNKCAP_ASPMS () {0xc00;}' unless defined(&PCI_EXP_LNKCAP_ASPMS);
    eval 'sub PCI_EXP_LNKCAP_L0SEL () {0x7000;}' unless defined(&PCI_EXP_LNKCAP_L0SEL);
    eval 'sub PCI_EXP_LNKCAP_L1EL () {0x38000;}' unless defined(&PCI_EXP_LNKCAP_L1EL);
    eval 'sub PCI_EXP_LNKCAP_CLKPM () {0x40000;}' unless defined(&PCI_EXP_LNKCAP_CLKPM);
    eval 'sub PCI_EXP_LNKCAP_SDERC () {0x80000;}' unless defined(&PCI_EXP_LNKCAP_SDERC);
    eval 'sub PCI_EXP_LNKCAP_DLLLARC () {0x100000;}' unless defined(&PCI_EXP_LNKCAP_DLLLARC);
    eval 'sub PCI_EXP_LNKCAP_LBNC () {0x200000;}' unless defined(&PCI_EXP_LNKCAP_LBNC);
    eval 'sub PCI_EXP_LNKCAP_PN () {0xff000000;}' unless defined(&PCI_EXP_LNKCAP_PN);
    eval 'sub PCI_EXP_LNKCTL () {16;}' unless defined(&PCI_EXP_LNKCTL);
    eval 'sub PCI_EXP_LNKCTL_ASPMC () {0x3;}' unless defined(&PCI_EXP_LNKCTL_ASPMC);
    eval 'sub PCI_EXP_LNKCTL_RCB () {0x8;}' unless defined(&PCI_EXP_LNKCTL_RCB);
    eval 'sub PCI_EXP_LNKCTL_LD () {0x10;}' unless defined(&PCI_EXP_LNKCTL_LD);
    eval 'sub PCI_EXP_LNKCTL_RL () {0x20;}' unless defined(&PCI_EXP_LNKCTL_RL);
    eval 'sub PCI_EXP_LNKCTL_CCC () {0x40;}' unless defined(&PCI_EXP_LNKCTL_CCC);
    eval 'sub PCI_EXP_LNKCTL_ES () {0x80;}' unless defined(&PCI_EXP_LNKCTL_ES);
    eval 'sub PCI_EXP_LNKCTL_CLKREQ_EN () {0x100;}' unless defined(&PCI_EXP_LNKCTL_CLKREQ_EN);
    eval 'sub PCI_EXP_LNKCTL_HAWD () {0x200;}' unless defined(&PCI_EXP_LNKCTL_HAWD);
    eval 'sub PCI_EXP_LNKCTL_LBMIE () {0x400;}' unless defined(&PCI_EXP_LNKCTL_LBMIE);
    eval 'sub PCI_EXP_LNKCTL_LABIE () {0x800;}' unless defined(&PCI_EXP_LNKCTL_LABIE);
    eval 'sub PCI_EXP_LNKSTA () {18;}' unless defined(&PCI_EXP_LNKSTA);
    eval 'sub PCI_EXP_LNKSTA_CLS () {0xf;}' unless defined(&PCI_EXP_LNKSTA_CLS);
    eval 'sub PCI_EXP_LNKSTA_CLS_2_5GB () {0x1;}' unless defined(&PCI_EXP_LNKSTA_CLS_2_5GB);
    eval 'sub PCI_EXP_LNKSTA_CLS_5_0GB () {0x2;}' unless defined(&PCI_EXP_LNKSTA_CLS_5_0GB);
    eval 'sub PCI_EXP_LNKSTA_NLW () {0x3f0;}' unless defined(&PCI_EXP_LNKSTA_NLW);
    eval 'sub PCI_EXP_LNKSTA_NLW_SHIFT () {4;}' unless defined(&PCI_EXP_LNKSTA_NLW_SHIFT);
    eval 'sub PCI_EXP_LNKSTA_LT () {0x800;}' unless defined(&PCI_EXP_LNKSTA_LT);
    eval 'sub PCI_EXP_LNKSTA_SLC () {0x1000;}' unless defined(&PCI_EXP_LNKSTA_SLC);
    eval 'sub PCI_EXP_LNKSTA_DLLLA () {0x2000;}' unless defined(&PCI_EXP_LNKSTA_DLLLA);
    eval 'sub PCI_EXP_LNKSTA_LBMS () {0x4000;}' unless defined(&PCI_EXP_LNKSTA_LBMS);
    eval 'sub PCI_EXP_LNKSTA_LABS () {0x8000;}' unless defined(&PCI_EXP_LNKSTA_LABS);
    eval 'sub PCI_EXP_SLTCAP () {20;}' unless defined(&PCI_EXP_SLTCAP);
    eval 'sub PCI_EXP_SLTCAP_ABP () {0x1;}' unless defined(&PCI_EXP_SLTCAP_ABP);
    eval 'sub PCI_EXP_SLTCAP_PCP () {0x2;}' unless defined(&PCI_EXP_SLTCAP_PCP);
    eval 'sub PCI_EXP_SLTCAP_MRLSP () {0x4;}' unless defined(&PCI_EXP_SLTCAP_MRLSP);
    eval 'sub PCI_EXP_SLTCAP_AIP () {0x8;}' unless defined(&PCI_EXP_SLTCAP_AIP);
    eval 'sub PCI_EXP_SLTCAP_PIP () {0x10;}' unless defined(&PCI_EXP_SLTCAP_PIP);
    eval 'sub PCI_EXP_SLTCAP_HPS () {0x20;}' unless defined(&PCI_EXP_SLTCAP_HPS);
    eval 'sub PCI_EXP_SLTCAP_HPC () {0x40;}' unless defined(&PCI_EXP_SLTCAP_HPC);
    eval 'sub PCI_EXP_SLTCAP_SPLV () {0x7f80;}' unless defined(&PCI_EXP_SLTCAP_SPLV);
    eval 'sub PCI_EXP_SLTCAP_SPLS () {0x18000;}' unless defined(&PCI_EXP_SLTCAP_SPLS);
    eval 'sub PCI_EXP_SLTCAP_EIP () {0x20000;}' unless defined(&PCI_EXP_SLTCAP_EIP);
    eval 'sub PCI_EXP_SLTCAP_NCCS () {0x40000;}' unless defined(&PCI_EXP_SLTCAP_NCCS);
    eval 'sub PCI_EXP_SLTCAP_PSN () {0xfff80000;}' unless defined(&PCI_EXP_SLTCAP_PSN);
    eval 'sub PCI_EXP_SLTCTL () {24;}' unless defined(&PCI_EXP_SLTCTL);
    eval 'sub PCI_EXP_SLTCTL_ABPE () {0x1;}' unless defined(&PCI_EXP_SLTCTL_ABPE);
    eval 'sub PCI_EXP_SLTCTL_PFDE () {0x2;}' unless defined(&PCI_EXP_SLTCTL_PFDE);
    eval 'sub PCI_EXP_SLTCTL_MRLSCE () {0x4;}' unless defined(&PCI_EXP_SLTCTL_MRLSCE);
    eval 'sub PCI_EXP_SLTCTL_PDCE () {0x8;}' unless defined(&PCI_EXP_SLTCTL_PDCE);
    eval 'sub PCI_EXP_SLTCTL_CCIE () {0x10;}' unless defined(&PCI_EXP_SLTCTL_CCIE);
    eval 'sub PCI_EXP_SLTCTL_HPIE () {0x20;}' unless defined(&PCI_EXP_SLTCTL_HPIE);
    eval 'sub PCI_EXP_SLTCTL_AIC () {0xc0;}' unless defined(&PCI_EXP_SLTCTL_AIC);
    eval 'sub PCI_EXP_SLTCTL_PIC () {0x300;}' unless defined(&PCI_EXP_SLTCTL_PIC);
    eval 'sub PCI_EXP_SLTCTL_PCC () {0x400;}' unless defined(&PCI_EXP_SLTCTL_PCC);
    eval 'sub PCI_EXP_SLTCTL_EIC () {0x800;}' unless defined(&PCI_EXP_SLTCTL_EIC);
    eval 'sub PCI_EXP_SLTCTL_DLLSCE () {0x1000;}' unless defined(&PCI_EXP_SLTCTL_DLLSCE);
    eval 'sub PCI_EXP_SLTSTA () {26;}' unless defined(&PCI_EXP_SLTSTA);
    eval 'sub PCI_EXP_SLTSTA_ABP () {0x1;}' unless defined(&PCI_EXP_SLTSTA_ABP);
    eval 'sub PCI_EXP_SLTSTA_PFD () {0x2;}' unless defined(&PCI_EXP_SLTSTA_PFD);
    eval 'sub PCI_EXP_SLTSTA_MRLSC () {0x4;}' unless defined(&PCI_EXP_SLTSTA_MRLSC);
    eval 'sub PCI_EXP_SLTSTA_PDC () {0x8;}' unless defined(&PCI_EXP_SLTSTA_PDC);
    eval 'sub PCI_EXP_SLTSTA_CC () {0x10;}' unless defined(&PCI_EXP_SLTSTA_CC);
    eval 'sub PCI_EXP_SLTSTA_MRLSS () {0x20;}' unless defined(&PCI_EXP_SLTSTA_MRLSS);
    eval 'sub PCI_EXP_SLTSTA_PDS () {0x40;}' unless defined(&PCI_EXP_SLTSTA_PDS);
    eval 'sub PCI_EXP_SLTSTA_EIS () {0x80;}' unless defined(&PCI_EXP_SLTSTA_EIS);
    eval 'sub PCI_EXP_SLTSTA_DLLSC () {0x100;}' unless defined(&PCI_EXP_SLTSTA_DLLSC);
    eval 'sub PCI_EXP_RTCTL () {28;}' unless defined(&PCI_EXP_RTCTL);
    eval 'sub PCI_EXP_RTCTL_SECEE () {0x1;}' unless defined(&PCI_EXP_RTCTL_SECEE);
    eval 'sub PCI_EXP_RTCTL_SENFEE () {0x2;}' unless defined(&PCI_EXP_RTCTL_SENFEE);
    eval 'sub PCI_EXP_RTCTL_SEFEE () {0x4;}' unless defined(&PCI_EXP_RTCTL_SEFEE);
    eval 'sub PCI_EXP_RTCTL_PMEIE () {0x8;}' unless defined(&PCI_EXP_RTCTL_PMEIE);
    eval 'sub PCI_EXP_RTCTL_CRSSVE () {0x10;}' unless defined(&PCI_EXP_RTCTL_CRSSVE);
    eval 'sub PCI_EXP_RTCAP () {30;}' unless defined(&PCI_EXP_RTCAP);
    eval 'sub PCI_EXP_RTSTA () {32;}' unless defined(&PCI_EXP_RTSTA);
    eval 'sub PCI_EXP_DEVCAP2 () {36;}' unless defined(&PCI_EXP_DEVCAP2);
    eval 'sub PCI_EXP_DEVCAP2_ARI () {0x20;}' unless defined(&PCI_EXP_DEVCAP2_ARI);
    eval 'sub PCI_EXP_DEVCTL2 () {40;}' unless defined(&PCI_EXP_DEVCTL2);
    eval 'sub PCI_EXP_DEVCTL2_ARI () {0x20;}' unless defined(&PCI_EXP_DEVCTL2_ARI);
    eval 'sub PCI_EXP_LNKCTL2 () {48;}' unless defined(&PCI_EXP_LNKCTL2);
    eval 'sub PCI_EXP_SLTCTL2 () {56;}' unless defined(&PCI_EXP_SLTCTL2);
    eval 'sub PCI_EXT_CAP_ID {
        my($header) = @_;
	    eval q(($header & 0xffff));
    }' unless defined(&PCI_EXT_CAP_ID);
    eval 'sub PCI_EXT_CAP_VER {
        my($header) = @_;
	    eval q((($header >> 16) & 0xf));
    }' unless defined(&PCI_EXT_CAP_VER);
    eval 'sub PCI_EXT_CAP_NEXT {
        my($header) = @_;
	    eval q((($header >> 20) & 0xffc));
    }' unless defined(&PCI_EXT_CAP_NEXT);
    eval 'sub PCI_EXT_CAP_ID_ERR () {1;}' unless defined(&PCI_EXT_CAP_ID_ERR);
    eval 'sub PCI_EXT_CAP_ID_VC () {2;}' unless defined(&PCI_EXT_CAP_ID_VC);
    eval 'sub PCI_EXT_CAP_ID_DSN () {3;}' unless defined(&PCI_EXT_CAP_ID_DSN);
    eval 'sub PCI_EXT_CAP_ID_PWR () {4;}' unless defined(&PCI_EXT_CAP_ID_PWR);
    eval 'sub PCI_EXT_CAP_ID_VNDR () {11;}' unless defined(&PCI_EXT_CAP_ID_VNDR);
    eval 'sub PCI_EXT_CAP_ID_ACS () {13;}' unless defined(&PCI_EXT_CAP_ID_ACS);
    eval 'sub PCI_EXT_CAP_ID_ARI () {14;}' unless defined(&PCI_EXT_CAP_ID_ARI);
    eval 'sub PCI_EXT_CAP_ID_ATS () {15;}' unless defined(&PCI_EXT_CAP_ID_ATS);
    eval 'sub PCI_EXT_CAP_ID_SRIOV () {16;}' unless defined(&PCI_EXT_CAP_ID_SRIOV);
    eval 'sub PCI_ERR_UNCOR_STATUS () {4;}' unless defined(&PCI_ERR_UNCOR_STATUS);
    eval 'sub PCI_ERR_UNC_TRAIN () {0x1;}' unless defined(&PCI_ERR_UNC_TRAIN);
    eval 'sub PCI_ERR_UNC_DLP () {0x10;}' unless defined(&PCI_ERR_UNC_DLP);
    eval 'sub PCI_ERR_UNC_POISON_TLP () {0x1000;}' unless defined(&PCI_ERR_UNC_POISON_TLP);
    eval 'sub PCI_ERR_UNC_FCP () {0x2000;}' unless defined(&PCI_ERR_UNC_FCP);
    eval 'sub PCI_ERR_UNC_COMP_TIME () {0x4000;}' unless defined(&PCI_ERR_UNC_COMP_TIME);
    eval 'sub PCI_ERR_UNC_COMP_ABORT () {0x8000;}' unless defined(&PCI_ERR_UNC_COMP_ABORT);
    eval 'sub PCI_ERR_UNC_UNX_COMP () {0x10000;}' unless defined(&PCI_ERR_UNC_UNX_COMP);
    eval 'sub PCI_ERR_UNC_RX_OVER () {0x20000;}' unless defined(&PCI_ERR_UNC_RX_OVER);
    eval 'sub PCI_ERR_UNC_MALF_TLP () {0x40000;}' unless defined(&PCI_ERR_UNC_MALF_TLP);
    eval 'sub PCI_ERR_UNC_ECRC () {0x80000;}' unless defined(&PCI_ERR_UNC_ECRC);
    eval 'sub PCI_ERR_UNC_UNSUP () {0x100000;}' unless defined(&PCI_ERR_UNC_UNSUP);
    eval 'sub PCI_ERR_UNCOR_MASK () {8;}' unless defined(&PCI_ERR_UNCOR_MASK);
    eval 'sub PCI_ERR_UNCOR_SEVER () {12;}' unless defined(&PCI_ERR_UNCOR_SEVER);
    eval 'sub PCI_ERR_COR_STATUS () {16;}' unless defined(&PCI_ERR_COR_STATUS);
    eval 'sub PCI_ERR_COR_RCVR () {0x1;}' unless defined(&PCI_ERR_COR_RCVR);
    eval 'sub PCI_ERR_COR_BAD_TLP () {0x40;}' unless defined(&PCI_ERR_COR_BAD_TLP);
    eval 'sub PCI_ERR_COR_BAD_DLLP () {0x80;}' unless defined(&PCI_ERR_COR_BAD_DLLP);
    eval 'sub PCI_ERR_COR_REP_ROLL () {0x100;}' unless defined(&PCI_ERR_COR_REP_ROLL);
    eval 'sub PCI_ERR_COR_REP_TIMER () {0x1000;}' unless defined(&PCI_ERR_COR_REP_TIMER);
    eval 'sub PCI_ERR_COR_MASK () {20;}' unless defined(&PCI_ERR_COR_MASK);
    eval 'sub PCI_ERR_CAP () {24;}' unless defined(&PCI_ERR_CAP);
    eval 'sub PCI_ERR_CAP_FEP {
        my($x) = @_;
	    eval q((($x) & 31));
    }' unless defined(&PCI_ERR_CAP_FEP);
    eval 'sub PCI_ERR_CAP_ECRC_GENC () {0x20;}' unless defined(&PCI_ERR_CAP_ECRC_GENC);
    eval 'sub PCI_ERR_CAP_ECRC_GENE () {0x40;}' unless defined(&PCI_ERR_CAP_ECRC_GENE);
    eval 'sub PCI_ERR_CAP_ECRC_CHKC () {0x80;}' unless defined(&PCI_ERR_CAP_ECRC_CHKC);
    eval 'sub PCI_ERR_CAP_ECRC_CHKE () {0x100;}' unless defined(&PCI_ERR_CAP_ECRC_CHKE);
    eval 'sub PCI_ERR_HEADER_LOG () {28;}' unless defined(&PCI_ERR_HEADER_LOG);
    eval 'sub PCI_ERR_ROOT_COMMAND () {44;}' unless defined(&PCI_ERR_ROOT_COMMAND);
    eval 'sub PCI_ERR_ROOT_CMD_COR_EN () {0x1;}' unless defined(&PCI_ERR_ROOT_CMD_COR_EN);
    eval 'sub PCI_ERR_ROOT_CMD_NONFATAL_EN () {0x2;}' unless defined(&PCI_ERR_ROOT_CMD_NONFATAL_EN);
    eval 'sub PCI_ERR_ROOT_CMD_FATAL_EN () {0x4;}' unless defined(&PCI_ERR_ROOT_CMD_FATAL_EN);
    eval 'sub PCI_ERR_ROOT_STATUS () {48;}' unless defined(&PCI_ERR_ROOT_STATUS);
    eval 'sub PCI_ERR_ROOT_COR_RCV () {0x1;}' unless defined(&PCI_ERR_ROOT_COR_RCV);
    eval 'sub PCI_ERR_ROOT_MULTI_COR_RCV () {0x2;}' unless defined(&PCI_ERR_ROOT_MULTI_COR_RCV);
    eval 'sub PCI_ERR_ROOT_UNCOR_RCV () {0x4;}' unless defined(&PCI_ERR_ROOT_UNCOR_RCV);
    eval 'sub PCI_ERR_ROOT_MULTI_UNCOR_RCV () {0x8;}' unless defined(&PCI_ERR_ROOT_MULTI_UNCOR_RCV);
    eval 'sub PCI_ERR_ROOT_FIRST_FATAL () {0x10;}' unless defined(&PCI_ERR_ROOT_FIRST_FATAL);
    eval 'sub PCI_ERR_ROOT_NONFATAL_RCV () {0x20;}' unless defined(&PCI_ERR_ROOT_NONFATAL_RCV);
    eval 'sub PCI_ERR_ROOT_FATAL_RCV () {0x40;}' unless defined(&PCI_ERR_ROOT_FATAL_RCV);
    eval 'sub PCI_ERR_ROOT_ERR_SRC () {52;}' unless defined(&PCI_ERR_ROOT_ERR_SRC);
    eval 'sub PCI_VC_PORT_REG1 () {4;}' unless defined(&PCI_VC_PORT_REG1);
    eval 'sub PCI_VC_PORT_REG2 () {8;}' unless defined(&PCI_VC_PORT_REG2);
    eval 'sub PCI_VC_PORT_CTRL () {12;}' unless defined(&PCI_VC_PORT_CTRL);
    eval 'sub PCI_VC_PORT_STATUS () {14;}' unless defined(&PCI_VC_PORT_STATUS);
    eval 'sub PCI_VC_RES_CAP () {16;}' unless defined(&PCI_VC_RES_CAP);
    eval 'sub PCI_VC_RES_CTRL () {20;}' unless defined(&PCI_VC_RES_CTRL);
    eval 'sub PCI_VC_RES_STATUS () {26;}' unless defined(&PCI_VC_RES_STATUS);
    eval 'sub PCI_PWR_DSR () {4;}' unless defined(&PCI_PWR_DSR);
    eval 'sub PCI_PWR_DATA () {8;}' unless defined(&PCI_PWR_DATA);
    eval 'sub PCI_PWR_DATA_BASE {
        my($x) = @_;
	    eval q((($x) & 0xff));
    }' unless defined(&PCI_PWR_DATA_BASE);
    eval 'sub PCI_PWR_DATA_SCALE {
        my($x) = @_;
	    eval q(((($x) >> 8) & 3));
    }' unless defined(&PCI_PWR_DATA_SCALE);
    eval 'sub PCI_PWR_DATA_PM_SUB {
        my($x) = @_;
	    eval q(((($x) >> 10) & 7));
    }' unless defined(&PCI_PWR_DATA_PM_SUB);
    eval 'sub PCI_PWR_DATA_PM_STATE {
        my($x) = @_;
	    eval q(((($x) >> 13) & 3));
    }' unless defined(&PCI_PWR_DATA_PM_STATE);
    eval 'sub PCI_PWR_DATA_TYPE {
        my($x) = @_;
	    eval q(((($x) >> 15) & 7));
    }' unless defined(&PCI_PWR_DATA_TYPE);
    eval 'sub PCI_PWR_DATA_RAIL {
        my($x) = @_;
	    eval q(((($x) >> 18) & 7));
    }' unless defined(&PCI_PWR_DATA_RAIL);
    eval 'sub PCI_PWR_CAP () {12;}' unless defined(&PCI_PWR_CAP);
    eval 'sub PCI_PWR_CAP_BUDGET {
        my($x) = @_;
	    eval q((($x) & 1));
    }' unless defined(&PCI_PWR_CAP_BUDGET);
    eval 'sub HT_3BIT_CAP_MASK () {0xe0;}' unless defined(&HT_3BIT_CAP_MASK);
    eval 'sub HT_CAPTYPE_SLAVE () {0x;}' unless defined(&HT_CAPTYPE_SLAVE);
    eval 'sub HT_CAPTYPE_HOST () {0x20;}' unless defined(&HT_CAPTYPE_HOST);
    eval 'sub HT_5BIT_CAP_MASK () {0xf8;}' unless defined(&HT_5BIT_CAP_MASK);
    eval 'sub HT_CAPTYPE_IRQ () {0x80;}' unless defined(&HT_CAPTYPE_IRQ);
    eval 'sub HT_CAPTYPE_REMAPPING_40 () {0xa0;}' unless defined(&HT_CAPTYPE_REMAPPING_40);
    eval 'sub HT_CAPTYPE_REMAPPING_64 () {0xa2;}' unless defined(&HT_CAPTYPE_REMAPPING_64);
    eval 'sub HT_CAPTYPE_UNITID_CLUMP () {0x90;}' unless defined(&HT_CAPTYPE_UNITID_CLUMP);
    eval 'sub HT_CAPTYPE_EXTCONF () {0x98;}' unless defined(&HT_CAPTYPE_EXTCONF);
    eval 'sub HT_CAPTYPE_MSI_MAPPING () {0xa8;}' unless defined(&HT_CAPTYPE_MSI_MAPPING);
    eval 'sub HT_MSI_FLAGS () {0x2;}' unless defined(&HT_MSI_FLAGS);
    eval 'sub HT_MSI_FLAGS_ENABLE () {0x1;}' unless defined(&HT_MSI_FLAGS_ENABLE);
    eval 'sub HT_MSI_FLAGS_FIXED () {0x2;}' unless defined(&HT_MSI_FLAGS_FIXED);
    eval 'sub HT_MSI_FIXED_ADDR () {0xfee00000;}' unless defined(&HT_MSI_FIXED_ADDR);
    eval 'sub HT_MSI_ADDR_LO () {0x4;}' unless defined(&HT_MSI_ADDR_LO);
    eval 'sub HT_MSI_ADDR_LO_MASK () {0xfff00000;}' unless defined(&HT_MSI_ADDR_LO_MASK);
    eval 'sub HT_MSI_ADDR_HI () {0x8;}' unless defined(&HT_MSI_ADDR_HI);
    eval 'sub HT_CAPTYPE_DIRECT_ROUTE () {0xb0;}' unless defined(&HT_CAPTYPE_DIRECT_ROUTE);
    eval 'sub HT_CAPTYPE_VCSET () {0xb8;}' unless defined(&HT_CAPTYPE_VCSET);
    eval 'sub HT_CAPTYPE_ERROR_RETRY () {0xc0;}' unless defined(&HT_CAPTYPE_ERROR_RETRY);
    eval 'sub HT_CAPTYPE_GEN3 () {0xd0;}' unless defined(&HT_CAPTYPE_GEN3);
    eval 'sub HT_CAPTYPE_PM () {0xe0;}' unless defined(&HT_CAPTYPE_PM);
    eval 'sub PCI_ARI_CAP () {0x4;}' unless defined(&PCI_ARI_CAP);
    eval 'sub PCI_ARI_CAP_MFVC () {0x1;}' unless defined(&PCI_ARI_CAP_MFVC);
    eval 'sub PCI_ARI_CAP_ACS () {0x2;}' unless defined(&PCI_ARI_CAP_ACS);
    eval 'sub PCI_ARI_CAP_NFN {
        my($x) = @_;
	    eval q(((($x) >> 8) & 0xff));
    }' unless defined(&PCI_ARI_CAP_NFN);
    eval 'sub PCI_ARI_CTRL () {0x6;}' unless defined(&PCI_ARI_CTRL);
    eval 'sub PCI_ARI_CTRL_MFVC () {0x1;}' unless defined(&PCI_ARI_CTRL_MFVC);
    eval 'sub PCI_ARI_CTRL_ACS () {0x2;}' unless defined(&PCI_ARI_CTRL_ACS);
    eval 'sub PCI_ARI_CTRL_FG {
        my($x) = @_;
	    eval q(((($x) >> 4) & 7));
    }' unless defined(&PCI_ARI_CTRL_FG);
    eval 'sub PCI_ATS_CAP () {0x4;}' unless defined(&PCI_ATS_CAP);
    eval 'sub PCI_ATS_CAP_QDEP {
        my($x) = @_;
	    eval q((($x) & 0x1f));
    }' unless defined(&PCI_ATS_CAP_QDEP);
    eval 'sub PCI_ATS_MAX_QDEP () {32;}' unless defined(&PCI_ATS_MAX_QDEP);
    eval 'sub PCI_ATS_CTRL () {0x6;}' unless defined(&PCI_ATS_CTRL);
    eval 'sub PCI_ATS_CTRL_ENABLE () {0x8000;}' unless defined(&PCI_ATS_CTRL_ENABLE);
    eval 'sub PCI_ATS_CTRL_STU {
        my($x) = @_;
	    eval q((($x) & 0x1f));
    }' unless defined(&PCI_ATS_CTRL_STU);
    eval 'sub PCI_ATS_MIN_STU () {12;}' unless defined(&PCI_ATS_MIN_STU);
    eval 'sub PCI_SRIOV_CAP () {0x4;}' unless defined(&PCI_SRIOV_CAP);
    eval 'sub PCI_SRIOV_CAP_VFM () {0x1;}' unless defined(&PCI_SRIOV_CAP_VFM);
    eval 'sub PCI_SRIOV_CAP_INTR {
        my($x) = @_;
	    eval q((($x) >> 21));
    }' unless defined(&PCI_SRIOV_CAP_INTR);
    eval 'sub PCI_SRIOV_CTRL () {0x8;}' unless defined(&PCI_SRIOV_CTRL);
    eval 'sub PCI_SRIOV_CTRL_VFE () {0x1;}' unless defined(&PCI_SRIOV_CTRL_VFE);
    eval 'sub PCI_SRIOV_CTRL_VFM () {0x2;}' unless defined(&PCI_SRIOV_CTRL_VFM);
    eval 'sub PCI_SRIOV_CTRL_INTR () {0x4;}' unless defined(&PCI_SRIOV_CTRL_INTR);
    eval 'sub PCI_SRIOV_CTRL_MSE () {0x8;}' unless defined(&PCI_SRIOV_CTRL_MSE);
    eval 'sub PCI_SRIOV_CTRL_ARI () {0x10;}' unless defined(&PCI_SRIOV_CTRL_ARI);
    eval 'sub PCI_SRIOV_STATUS () {0xa;}' unless defined(&PCI_SRIOV_STATUS);
    eval 'sub PCI_SRIOV_STATUS_VFM () {0x1;}' unless defined(&PCI_SRIOV_STATUS_VFM);
    eval 'sub PCI_SRIOV_INITIAL_VF () {0xc;}' unless defined(&PCI_SRIOV_INITIAL_VF);
    eval 'sub PCI_SRIOV_TOTAL_VF () {0xe;}' unless defined(&PCI_SRIOV_TOTAL_VF);
    eval 'sub PCI_SRIOV_NUM_VF () {0x10;}' unless defined(&PCI_SRIOV_NUM_VF);
    eval 'sub PCI_SRIOV_FUNC_LINK () {0x12;}' unless defined(&PCI_SRIOV_FUNC_LINK);
    eval 'sub PCI_SRIOV_VF_OFFSET () {0x14;}' unless defined(&PCI_SRIOV_VF_OFFSET);
    eval 'sub PCI_SRIOV_VF_STRIDE () {0x16;}' unless defined(&PCI_SRIOV_VF_STRIDE);
    eval 'sub PCI_SRIOV_VF_DID () {0x1a;}' unless defined(&PCI_SRIOV_VF_DID);
    eval 'sub PCI_SRIOV_SUP_PGSIZE () {0x1c;}' unless defined(&PCI_SRIOV_SUP_PGSIZE);
    eval 'sub PCI_SRIOV_SYS_PGSIZE () {0x20;}' unless defined(&PCI_SRIOV_SYS_PGSIZE);
    eval 'sub PCI_SRIOV_BAR () {0x24;}' unless defined(&PCI_SRIOV_BAR);
    eval 'sub PCI_SRIOV_NUM_BARS () {6;}' unless defined(&PCI_SRIOV_NUM_BARS);
    eval 'sub PCI_SRIOV_VFM () {0x3c;}' unless defined(&PCI_SRIOV_VFM);
    eval 'sub PCI_SRIOV_VFM_BIR {
        my($x) = @_;
	    eval q((($x) & 7));
    }' unless defined(&PCI_SRIOV_VFM_BIR);
    eval 'sub PCI_SRIOV_VFM_OFFSET {
        my($x) = @_;
	    eval q((($x) & ~7));
    }' unless defined(&PCI_SRIOV_VFM_OFFSET);
    eval 'sub PCI_SRIOV_VFM_UA () {0x;}' unless defined(&PCI_SRIOV_VFM_UA);
    eval 'sub PCI_SRIOV_VFM_MI () {0x1;}' unless defined(&PCI_SRIOV_VFM_MI);
    eval 'sub PCI_SRIOV_VFM_MO () {0x2;}' unless defined(&PCI_SRIOV_VFM_MO);
    eval 'sub PCI_SRIOV_VFM_AV () {0x3;}' unless defined(&PCI_SRIOV_VFM_AV);
    eval 'sub PCI_ACS_CAP () {0x4;}' unless defined(&PCI_ACS_CAP);
    eval 'sub PCI_ACS_SV () {0x1;}' unless defined(&PCI_ACS_SV);
    eval 'sub PCI_ACS_TB () {0x2;}' unless defined(&PCI_ACS_TB);
    eval 'sub PCI_ACS_RR () {0x4;}' unless defined(&PCI_ACS_RR);
    eval 'sub PCI_ACS_CR () {0x8;}' unless defined(&PCI_ACS_CR);
    eval 'sub PCI_ACS_UF () {0x10;}' unless defined(&PCI_ACS_UF);
    eval 'sub PCI_ACS_EC () {0x20;}' unless defined(&PCI_ACS_EC);
    eval 'sub PCI_ACS_DT () {0x40;}' unless defined(&PCI_ACS_DT);
    eval 'sub PCI_ACS_CTRL () {0x6;}' unless defined(&PCI_ACS_CTRL);
    eval 'sub PCI_ACS_EGRESS_CTL_V () {0x8;}' unless defined(&PCI_ACS_EGRESS_CTL_V);
}
1;
