require Exporter;
package LIMAL::LogHelper;
@ISA = qw( LIMAL );

use LIMAL;

sub log {
    my $type    = shift || "ERROR";
    my $message = shift;
    %__error = @_;
    my $s = "";

    my ($p, $f, $l) = caller(1);

    if(!$__error{'package'} ) {
        $__error{'package'} = $p;
    }
    if(!$__error{'file'} ) {
        $__error{'file'} = $f;
    }
    if(!$__error{'line'}) {
        $__error{'line'} = $l;
    }
    if(!$__error{'subroutine'}) {
        ($p, $f, $l, $s) = caller(2);
        $__error{'subroutine'} = $s || '';
    }
    $message = '' unless defined($message);

    my $logger = new LIMAL::Logger($__error{package});
    $logger->logMessage("$type", "$message", "$__error{'file'}", 
                        $__error{'line'}, "$__error{'subroutine'}");
}

sub logFatal {
    my $message = shift;
    #%__error = @_;
    LIMAL::LogHelper::log("FATAL", $message, @_);
}

sub logError {
    my $message = shift;
    #%__error = @_;
    LIMAL::LogHelper::log("ERROR", $message, @_);
}

sub logInfo {
    my $message = shift;
    #%__error = @_;
    LIMAL::LogHelper::log("INFO", $message, @_);
}

sub logDebug {
    my $message = shift;
    #%__error = @_;
    LIMAL::LogHelper::log("DEBUG", $message, @_);
}

@LIMAL::LogHelper::ISA = qw(Exporter);
@LIMAL::LogHelper::EXPORT = qw(
                               &logFatal
                               &logError
                               &logInfo
                               &logDebug
                              );
$LIMAL::LogHelper = "1.0";

1;
