require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_USB_AUDIO_H)) {
    eval 'sub __LINUX_USB_AUDIO_H () {1;}' unless defined(&__LINUX_USB_AUDIO_H);
    require 'linux/types.ph';
    eval 'sub USB_SUBCLASS_AUDIOCONTROL () {0x1;}' unless defined(&USB_SUBCLASS_AUDIOCONTROL);
    eval 'sub USB_SUBCLASS_AUDIOSTREAMING () {0x2;}' unless defined(&USB_SUBCLASS_AUDIOSTREAMING);
    eval 'sub USB_SUBCLASS_MIDISTREAMING () {0x3;}' unless defined(&USB_SUBCLASS_MIDISTREAMING);
    eval 'sub USB_SUBCLASS_VENDOR_SPEC () {0xff;}' unless defined(&USB_SUBCLASS_VENDOR_SPEC);
    eval 'sub HEADER () {0x1;}' unless defined(&HEADER);
    eval 'sub INPUT_TERMINAL () {0x2;}' unless defined(&INPUT_TERMINAL);
    eval 'sub OUTPUT_TERMINAL () {0x3;}' unless defined(&OUTPUT_TERMINAL);
    eval 'sub MIXER_UNIT () {0x4;}' unless defined(&MIXER_UNIT);
    eval 'sub SELECTOR_UNIT () {0x5;}' unless defined(&SELECTOR_UNIT);
    eval 'sub FEATURE_UNIT () {0x6;}' unless defined(&FEATURE_UNIT);
    eval 'sub PROCESSING_UNIT () {0x7;}' unless defined(&PROCESSING_UNIT);
    eval 'sub EXTENSION_UNIT () {0x8;}' unless defined(&EXTENSION_UNIT);
    eval 'sub AS_GENERAL () {0x1;}' unless defined(&AS_GENERAL);
    eval 'sub FORMAT_TYPE () {0x2;}' unless defined(&FORMAT_TYPE);
    eval 'sub FORMAT_SPECIFIC () {0x3;}' unless defined(&FORMAT_SPECIFIC);
    eval 'sub EP_GENERAL () {0x1;}' unless defined(&EP_GENERAL);
    eval 'sub MS_GENERAL () {0x1;}' unless defined(&MS_GENERAL);
    eval 'sub MIDI_IN_JACK () {0x2;}' unless defined(&MIDI_IN_JACK);
    eval 'sub MIDI_OUT_JACK () {0x3;}' unless defined(&MIDI_OUT_JACK);
    eval 'sub EP_ATTR_MASK () {0xc;}' unless defined(&EP_ATTR_MASK);
    eval 'sub EP_ATTR_ASYNC () {0x4;}' unless defined(&EP_ATTR_ASYNC);
    eval 'sub EP_ATTR_ADAPTIVE () {0x8;}' unless defined(&EP_ATTR_ADAPTIVE);
    eval 'sub EP_ATTR_SYNC () {0xc;}' unless defined(&EP_ATTR_SYNC);
    eval 'sub EP_CS_ATTR_SAMPLE_RATE () {0x1;}' unless defined(&EP_CS_ATTR_SAMPLE_RATE);
    eval 'sub EP_CS_ATTR_PITCH_CONTROL () {0x2;}' unless defined(&EP_CS_ATTR_PITCH_CONTROL);
    eval 'sub EP_CS_ATTR_FILL_MAX () {0x80;}' unless defined(&EP_CS_ATTR_FILL_MAX);
    eval 'sub USB_AUDIO_SET_INTF () {0x21;}' unless defined(&USB_AUDIO_SET_INTF);
    eval 'sub USB_AUDIO_SET_ENDPOINT () {0x22;}' unless defined(&USB_AUDIO_SET_ENDPOINT);
    eval 'sub USB_AUDIO_GET_INTF () {0xa1;}' unless defined(&USB_AUDIO_GET_INTF);
    eval 'sub USB_AUDIO_GET_ENDPOINT () {0xa2;}' unless defined(&USB_AUDIO_GET_ENDPOINT);
    eval 'sub SET_ () {0x;}' unless defined(&SET_);
    eval 'sub GET_ () {0x80;}' unless defined(&GET_);
    eval 'sub _CUR () {0x1;}' unless defined(&_CUR);
    eval 'sub _MIN () {0x2;}' unless defined(&_MIN);
    eval 'sub _MAX () {0x3;}' unless defined(&_MAX);
    eval 'sub _RES () {0x4;}' unless defined(&_RES);
    eval 'sub _MEM () {0x5;}' unless defined(&_MEM);
    eval 'sub SET_CUR () {( &SET_ |  &_CUR);}' unless defined(&SET_CUR);
    eval 'sub GET_CUR () {( &GET_ |  &_CUR);}' unless defined(&GET_CUR);
    eval 'sub SET_MIN () {( &SET_ |  &_MIN);}' unless defined(&SET_MIN);
    eval 'sub GET_MIN () {( &GET_ |  &_MIN);}' unless defined(&GET_MIN);
    eval 'sub SET_MAX () {( &SET_ |  &_MAX);}' unless defined(&SET_MAX);
    eval 'sub GET_MAX () {( &GET_ |  &_MAX);}' unless defined(&GET_MAX);
    eval 'sub SET_RES () {( &SET_ |  &_RES);}' unless defined(&SET_RES);
    eval 'sub GET_RES () {( &GET_ |  &_RES);}' unless defined(&GET_RES);
    eval 'sub SET_MEM () {( &SET_ |  &_MEM);}' unless defined(&SET_MEM);
    eval 'sub GET_MEM () {( &GET_ |  &_MEM);}' unless defined(&GET_MEM);
    eval 'sub GET_STAT () {0xff;}' unless defined(&GET_STAT);
    eval 'sub USB_AC_TERMINAL_UNDEFINED () {0x100;}' unless defined(&USB_AC_TERMINAL_UNDEFINED);
    eval 'sub USB_AC_TERMINAL_STREAMING () {0x101;}' unless defined(&USB_AC_TERMINAL_STREAMING);
    eval 'sub USB_AC_TERMINAL_VENDOR_SPEC () {0x1ff;}' unless defined(&USB_AC_TERMINAL_VENDOR_SPEC);
    eval 'sub USB_DT_AC_HEADER_SIZE {
        my($n) = @_;
	    eval q((8+ ($n)));
    }' unless defined(&USB_DT_AC_HEADER_SIZE);
    eval 'sub DECLARE_USB_AC_HEADER_DESCRIPTOR {
        my($n) = @_;
	    eval q(\'struct usb_ac_header_descriptor_\'$n {  &__u8  &bLength;  &__u8  &bDescriptorType;  &__u8  &bDescriptorSubtype;  &__le16  &bcdADC;  &__le16  &wTotalLength;  &__u8  &bInCollection;  &__u8  $baInterfaceNr[$n]; }  &__attribute__ (( &packed)));
    }' unless defined(&DECLARE_USB_AC_HEADER_DESCRIPTOR);
    eval 'sub USB_DT_AC_INPUT_TERMINAL_SIZE () {12;}' unless defined(&USB_DT_AC_INPUT_TERMINAL_SIZE);
    eval 'sub USB_AC_INPUT_TERMINAL_UNDEFINED () {0x200;}' unless defined(&USB_AC_INPUT_TERMINAL_UNDEFINED);
    eval 'sub USB_AC_INPUT_TERMINAL_MICROPHONE () {0x201;}' unless defined(&USB_AC_INPUT_TERMINAL_MICROPHONE);
    eval 'sub USB_AC_INPUT_TERMINAL_DESKTOP_MICROPHONE () {0x202;}' unless defined(&USB_AC_INPUT_TERMINAL_DESKTOP_MICROPHONE);
    eval 'sub USB_AC_INPUT_TERMINAL_PERSONAL_MICROPHONE () {0x203;}' unless defined(&USB_AC_INPUT_TERMINAL_PERSONAL_MICROPHONE);
    eval 'sub USB_AC_INPUT_TERMINAL_OMNI_DIR_MICROPHONE () {0x204;}' unless defined(&USB_AC_INPUT_TERMINAL_OMNI_DIR_MICROPHONE);
    eval 'sub USB_AC_INPUT_TERMINAL_MICROPHONE_ARRAY () {0x205;}' unless defined(&USB_AC_INPUT_TERMINAL_MICROPHONE_ARRAY);
    eval 'sub USB_AC_INPUT_TERMINAL_PROC_MICROPHONE_ARRAY () {0x206;}' unless defined(&USB_AC_INPUT_TERMINAL_PROC_MICROPHONE_ARRAY);
    eval 'sub USB_DT_AC_OUTPUT_TERMINAL_SIZE () {9;}' unless defined(&USB_DT_AC_OUTPUT_TERMINAL_SIZE);
    eval 'sub USB_AC_OUTPUT_TERMINAL_UNDEFINED () {0x300;}' unless defined(&USB_AC_OUTPUT_TERMINAL_UNDEFINED);
    eval 'sub USB_AC_OUTPUT_TERMINAL_SPEAKER () {0x301;}' unless defined(&USB_AC_OUTPUT_TERMINAL_SPEAKER);
    eval 'sub USB_AC_OUTPUT_TERMINAL_HEADPHONES () {0x302;}' unless defined(&USB_AC_OUTPUT_TERMINAL_HEADPHONES);
    eval 'sub USB_AC_OUTPUT_TERMINAL_HEAD_MOUNTED_DISPLAY_AUDIO () {0x303;}' unless defined(&USB_AC_OUTPUT_TERMINAL_HEAD_MOUNTED_DISPLAY_AUDIO);
    eval 'sub USB_AC_OUTPUT_TERMINAL_DESKTOP_SPEAKER () {0x304;}' unless defined(&USB_AC_OUTPUT_TERMINAL_DESKTOP_SPEAKER);
    eval 'sub USB_AC_OUTPUT_TERMINAL_ROOM_SPEAKER () {0x305;}' unless defined(&USB_AC_OUTPUT_TERMINAL_ROOM_SPEAKER);
    eval 'sub USB_AC_OUTPUT_TERMINAL_COMMUNICATION_SPEAKER () {0x306;}' unless defined(&USB_AC_OUTPUT_TERMINAL_COMMUNICATION_SPEAKER);
    eval 'sub USB_AC_OUTPUT_TERMINAL_LOW_FREQ_EFFECTS_SPEAKER () {0x307;}' unless defined(&USB_AC_OUTPUT_TERMINAL_LOW_FREQ_EFFECTS_SPEAKER);
    eval 'sub USB_DT_AC_FEATURE_UNIT_SIZE {
        my($ch) = @_;
	    eval q((7+ (($ch) + 1) * 2));
    }' unless defined(&USB_DT_AC_FEATURE_UNIT_SIZE);
    eval 'sub DECLARE_USB_AC_FEATURE_UNIT_DESCRIPTOR {
        my($ch) = @_;
	    eval q(\'struct usb_ac_feature_unit_descriptor_\'$ch {  &__u8  &bLength;  &__u8  &bDescriptorType;  &__u8  &bDescriptorSubtype;  &__u8  &bUnitID;  &__u8  &bSourceID;  &__u8  &bControlSize;  &__le16  $bmaControls[$ch + 1];  &__u8  &iFeature; }  &__attribute__ (( &packed)));
    }' unless defined(&DECLARE_USB_AC_FEATURE_UNIT_DESCRIPTOR);
    eval 'sub USB_DT_AS_HEADER_SIZE () {7;}' unless defined(&USB_DT_AS_HEADER_SIZE);
    eval 'sub USB_AS_AUDIO_FORMAT_TYPE_I_UNDEFINED () {0x;}' unless defined(&USB_AS_AUDIO_FORMAT_TYPE_I_UNDEFINED);
    eval 'sub USB_AS_AUDIO_FORMAT_TYPE_I_PCM () {0x1;}' unless defined(&USB_AS_AUDIO_FORMAT_TYPE_I_PCM);
    eval 'sub USB_AS_AUDIO_FORMAT_TYPE_I_PCM8 () {0x2;}' unless defined(&USB_AS_AUDIO_FORMAT_TYPE_I_PCM8);
    eval 'sub USB_AS_AUDIO_FORMAT_TYPE_I_IEEE_FLOAT () {0x3;}' unless defined(&USB_AS_AUDIO_FORMAT_TYPE_I_IEEE_FLOAT);
    eval 'sub USB_AS_AUDIO_FORMAT_TYPE_I_ALAW () {0x4;}' unless defined(&USB_AS_AUDIO_FORMAT_TYPE_I_ALAW);
    eval 'sub USB_AS_AUDIO_FORMAT_TYPE_I_MULAW () {0x5;}' unless defined(&USB_AS_AUDIO_FORMAT_TYPE_I_MULAW);
    eval 'sub USB_AS_FORMAT_TYPE_I_CONTINUOUS_DESC_SIZE () {14;}' unless defined(&USB_AS_FORMAT_TYPE_I_CONTINUOUS_DESC_SIZE);
    eval 'sub DECLARE_USB_AS_FORMAT_TYPE_I_DISCRETE_DESC {
        my($n) = @_;
	    eval q(\'struct usb_as_formate_type_i_discrete_descriptor_\'$n {  &__u8  &bLength;  &__u8  &bDescriptorType;  &__u8  &bDescriptorSubtype;  &__u8  &bFormatType;  &__u8  &bNrChannels;  &__u8  &bSubframeSize;  &__u8  &bBitResolution;  &__u8  &bSamFreqType;  &__u8  $tSamFreq[$n][3]; }  &__attribute__ (( &packed)));
    }' unless defined(&DECLARE_USB_AS_FORMAT_TYPE_I_DISCRETE_DESC);
    eval 'sub USB_AS_FORMAT_TYPE_I_DISCRETE_DESC_SIZE {
        my($n) = @_;
	    eval q((8+ ($n * 3)));
    }' unless defined(&USB_AS_FORMAT_TYPE_I_DISCRETE_DESC_SIZE);
    eval 'sub USB_AS_FORMAT_TYPE_UNDEFINED () {0x;}' unless defined(&USB_AS_FORMAT_TYPE_UNDEFINED);
    eval 'sub USB_AS_FORMAT_TYPE_I () {0x1;}' unless defined(&USB_AS_FORMAT_TYPE_I);
    eval 'sub USB_AS_FORMAT_TYPE_II () {0x2;}' unless defined(&USB_AS_FORMAT_TYPE_II);
    eval 'sub USB_AS_FORMAT_TYPE_III () {0x3;}' unless defined(&USB_AS_FORMAT_TYPE_III);
    eval 'sub USB_AS_ENDPOINT_ASYNC () {(1<< 2);}' unless defined(&USB_AS_ENDPOINT_ASYNC);
    eval 'sub USB_AS_ENDPOINT_ADAPTIVE () {(2<< 2);}' unless defined(&USB_AS_ENDPOINT_ADAPTIVE);
    eval 'sub USB_AS_ENDPOINT_SYNC () {(3<< 2);}' unless defined(&USB_AS_ENDPOINT_SYNC);
    eval 'sub USB_AS_ISO_ENDPOINT_DESC_SIZE () {7;}' unless defined(&USB_AS_ISO_ENDPOINT_DESC_SIZE);
    eval 'sub FU_CONTROL_UNDEFINED () {0x;}' unless defined(&FU_CONTROL_UNDEFINED);
    eval 'sub MUTE_CONTROL () {0x1;}' unless defined(&MUTE_CONTROL);
    eval 'sub VOLUME_CONTROL () {0x2;}' unless defined(&VOLUME_CONTROL);
    eval 'sub BASS_CONTROL () {0x3;}' unless defined(&BASS_CONTROL);
    eval 'sub MID_CONTROL () {0x4;}' unless defined(&MID_CONTROL);
    eval 'sub TREBLE_CONTROL () {0x5;}' unless defined(&TREBLE_CONTROL);
    eval 'sub GRAPHIC_EQUALIZER_CONTROL () {0x6;}' unless defined(&GRAPHIC_EQUALIZER_CONTROL);
    eval 'sub AUTOMATIC_GAIN_CONTROL () {0x7;}' unless defined(&AUTOMATIC_GAIN_CONTROL);
    eval 'sub DELAY_CONTROL () {0x8;}' unless defined(&DELAY_CONTROL);
    eval 'sub BASS_BOOST_CONTROL () {0x9;}' unless defined(&BASS_BOOST_CONTROL);
    eval 'sub LOUDNESS_CONTROL () {0xa;}' unless defined(&LOUDNESS_CONTROL);
    eval 'sub FU_MUTE () {(1<< ( &MUTE_CONTROL - 1));}' unless defined(&FU_MUTE);
    eval 'sub FU_VOLUME () {(1<< ( &VOLUME_CONTROL - 1));}' unless defined(&FU_VOLUME);
    eval 'sub FU_BASS () {(1<< ( &BASS_CONTROL - 1));}' unless defined(&FU_BASS);
    eval 'sub FU_MID () {(1<< ( &MID_CONTROL - 1));}' unless defined(&FU_MID);
    eval 'sub FU_TREBLE () {(1<< ( &TREBLE_CONTROL - 1));}' unless defined(&FU_TREBLE);
    eval 'sub FU_GRAPHIC_EQ () {(1<< ( &GRAPHIC_EQUALIZER_CONTROL - 1));}' unless defined(&FU_GRAPHIC_EQ);
    eval 'sub FU_AUTO_GAIN () {(1<< ( &AUTOMATIC_GAIN_CONTROL - 1));}' unless defined(&FU_AUTO_GAIN);
    eval 'sub FU_DELAY () {(1<< ( &DELAY_CONTROL - 1));}' unless defined(&FU_DELAY);
    eval 'sub FU_BASS_BOOST () {(1<< ( &BASS_BOOST_CONTROL - 1));}' unless defined(&FU_BASS_BOOST);
    eval 'sub FU_LOUDNESS () {(1<< ( &LOUDNESS_CONTROL - 1));}' unless defined(&FU_LOUDNESS);
    eval 'sub generic_set_cmd {
        my($con,$cmd,$value) = @_;
	    eval q({  ($con->{data[$cmd]}) = $value; 0; });
    }' unless defined(&generic_set_cmd);
    eval 'sub generic_get_cmd {
        my($con,$cmd) = @_;
	    eval q({  ($con->{data[$cmd]}); });
    }' unless defined(&generic_get_cmd);
}
1;
