#!/bin/bash
#
#%stage: softraid
#
mdblockdev=

for bd in $blockdev ; do
    # get information about the current blockdev
    update_blockdev $bd
    mdconf=$(mdadm -Db $bd 2> /dev/null | sed -n "s@/dev/md[0-9]*@/dev/md$blockminor@p")
    if [ -n "$mdconf" ] ; then
	md_tmpblockdev=$(mdadm -Dbv $bd 2> /dev/null | sed -n "1D;s/,/ /g;s/^ *devices=\(.*\)/\1/p")
	md_dev=${bd##/dev/}
	dup_found=0
	for dup in $md_devs; do
		if [ x"$dup" = x"$md_dev" ]; then
			dup_found=1
			break
		fi
	done
	if [ $dup_found -eq 0 ]; then
		mdblockdev="$mdblockdev $md_tmpblockdev"
		eval md_conf_${md_dev}=\"$mdconf\"
		md_devs="$md_devs $md_dev"
		root_md=1
	else
		echo "setup-md.sh: $md_dev found multiple times" >&2
	fi
    else
	mdblockdev="$mdblockdev $bd"
    fi
done

blockdev="$mdblockdev"

if [ -n "$root_md" ] ; then
    need_mdadm=1
    echo "DEVICE partitions" > $tmp_mnt/etc/mdadm.conf
    for md in $md_devs; do
        eval echo \$md_conf_$md >> $tmp_mnt/etc/mdadm.conf
    done
fi

save_var need_mdadm
save_var root_md
