/*
 *  include/ub/ub_task.h
 *
 *  Copyright (C) 2005  SWsoft
 *  All rights reserved.
 *
 */

#ifndef __UB_TASK_H_
#define __UB_TASK_H_

#include <linux/config.h>

struct user_beancounter;


#ifdef CONFIG_USER_RESOURCE

struct task_beancounter {
	struct user_beancounter	*exec_ub;
	struct user_beancounter	*task_ub;
	struct user_beancounter *fork_sub;
	void *task_fnode, *task_freserv;
	unsigned long task_data[4];
};

#define task_bc(__tsk) (&((__tsk)->task_bc)) 

#define get_exec_ub()		(task_bc(current)->exec_ub)
#define get_task_ub(__task)	(task_bc(__task)->task_ub)
#define set_exec_ub(__newub)		\
({					\
	struct user_beancounter *old;	\
	struct task_beancounter *tbc;	\
	tbc = task_bc(current);		\
	old = tbc->exec_ub;		\
	tbc->exec_ub = __newub;		\
	old;				\
})

#else /* CONFIG_USER_RESOURCE */

#define get_exec_ub()		(NULL)
#define get_task_ub(task)	(NULL)
#define set_exec_ub(__ub)	(NULL)

#endif /* CONFIG_USER_RESOURCE */
#endif /* __UB_TASK_H_ */
