/*
 *  include/ub/ub_sk.h
 *
 *  Copyright (C) 2005  SWsoft
 *  All rights reserved.
 *
 */

#ifndef __UB_SK_H_
#define __UB_SK_H_

#include <linux/config.h>
#include <ub/ub_task.h>

struct sock;
struct sk_buff;

struct skb_beancounter {
	struct user_beancounter *ub;
	unsigned long charged:27, resource:5;
};

struct sock_beancounter {
	/*
	 * already charged for future sends, to make poll work;
	 * changes are protected by bc spinlock, read is under socket
	 * semaphore for sends and unprotected in poll
	 */
	unsigned long           poll_reserv;
	unsigned long           ub_waitspc;     /* space waiting for */
	unsigned long           ub_wcharged;
	struct list_head        ub_sock_list;
	struct user_beancounter *ub;
};

#define sock_bc(__sk)		(&(__sk)->sk_bc)
#define skb_bc(__skb)		(&(__skb)->skb_bc)
#define skbc_sock(__skbc)	(container_of(__skbc, struct sock, sk_bc))
#define sock_has_ubc(__sk)	(sock_bc(__sk)->ub != NULL)

#define	set_sk_exec_ub(__sk)	(set_exec_ub(sock_bc(sk)->ub))

#endif
