/*
 *  include/ub/ub_misc.h
 *
 *  Copyright (C) 2005  SWsoft
 *  All rights reserved.
 *
 */

#ifndef __UB_MISC_H_
#define __UB_MISC_H_

#include <ub/ub_decl.h>

struct tty_struct;
struct file;
struct file_lock;

UB_DECLARE_FUNC(int, ub_file_charge(struct file *f))
UB_DECLARE_VOID_FUNC(ub_file_uncharge(struct file *f))
UB_DECLARE_FUNC(int, ub_flock_charge(struct file_lock *fl, int hard))
UB_DECLARE_VOID_FUNC(ub_flock_uncharge(struct file_lock *fl))
UB_DECLARE_FUNC(int, ub_siginfo_charge(struct user_beancounter *ub,
			unsigned long size))
UB_DECLARE_VOID_FUNC(ub_siginfo_uncharge(struct user_beancounter *ub,
			unsigned long size))
UB_DECLARE_FUNC(int, ub_task_charge(struct task_struct *parent,
			struct task_struct *task))
UB_DECLARE_VOID_FUNC(ub_task_uncharge(struct task_struct *task))
UB_DECLARE_FUNC(int, ub_pty_charge(struct tty_struct *tty))
UB_DECLARE_VOID_FUNC(ub_pty_uncharge(struct tty_struct *tty))
#endif
